import React from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import ServicesList from './ServicesList.jsx';
import NoArchiveServices from '../NoArchiveServices/NoArchiveServices.jsx';

const ArchiveDescription = ({titleText, tld}) => (
    <div className='getdata-archive'>
        <h3>{titleText}</h3>
        <ServicesList tld={tld} />
        <h3>{i18n('TakeOut.getdata_tech-services')}</h3>
        <div className='getdata_additional-info'>{i18n('TakeOut.getdata_tech-services-list')}</div>
        <NoArchiveServices tld={tld} />
    </div>
);

function mapStateToProps(state) {
    const {takeOutInfo} = state;
    const isReadyStatus = takeOutInfo.status === 'isReady';
    const titleText = isReadyStatus
        ? i18n('TakeOut.getdata_services-ready')
        : i18n('TakeOut.getdata_services-processing');

    return {
        titleText
    };
}

export default connect(mapStateToProps)(ArchiveDescription);

ArchiveDescription.propTypes = {
    titleText: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired
};
