import React from 'react';
import PropTypes from 'prop-types';
import services from './services';

const ServicesList = ({tld}) => (
    <div className='getdata-list_block'>
        <ul className='getdata-list'>
            {services.map((item) => (
                <li className={`icon-item getdata-icon-${item.id}`} key={item.id}>
                    <div className='getdata-data-descr'>
                        <h4 className='getdata-descr_title'>
                            {item.link ? (
                                <a href={item.link.replace('%tld', tld)} target='_blank' rel='noopener noreferrer'>
                                    {item.title}
                                </a>
                            ) : (
                                <span>{item.title}</span>
                            )}
                        </h4>
                        <p>{item.description}</p>
                    </div>
                </li>
            ))}
        </ul>
    </div>
);

export default ServicesList;

ServicesList.propTypes = {
    tld: PropTypes.string.isRequired
};
