import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import DataInfoContent from '../DataInfoContent/DataInfoContent.jsx';

const DataInfo = ({error}) => (
    <div className='getdata-info'>
        {error && <div className='getdata-error'>{error}</div>}
        <DataInfoContent />
    </div>
);

function mapStateToProps(state) {
    const {
        takeOutInfo: {error}
    } = state;

    return {
        error
    };
}

export default connect(mapStateToProps)(DataInfo);

DataInfo.propTypes = {
    error: PropTypes.string
};
