import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Button} from '@components/Button';
import {Spin} from '@components/Spin';
import mapDispatchToProps from './mapDispatchToProps';
import PasswordModal from '../PasswordModal/PasswordModal.jsx';
import SectionTitle from '../SectionTitle/SectionTitle.jsx';

class DataInfoContent extends Component {
    static mapStateToProps(state) {
        const {takeOutInfo, settings} = state;
        const isMobile = settings.ua.isMobile && !settings.ua.isTablet;

        return {
            takeOutInfo,
            isMobile
        };
    }

    render() {
        const {getArchiveData, requestDataArchive, getArchivePassword, takeOutInfo, isMobile} = this.props;
        const {status, archiveInfo = {}, isLoading} = takeOutInfo;
        const get7ZipLink = 'https://www.7-zip.org/download.html';
        const textWithLink = i18n('TakeOut.getdata_archive-ready').replace(
            '%link',
            `<a href=${get7ZipLink}>${get7ZipLink}</a>`
        );

        if (status === 'isBeingRequesting') {
            return (
                <div className='getdata-info-cols valign-middle'>
                    <span className='getdata-icon' role='presentation' />
                    <SectionTitle isMobile={isMobile} />
                    <div className='get-data-info__text'>{i18n('TakeOut.getdata_processing')}</div>
                </div>
            );
        }

        if (status === 'isReady') {
            return (
                <div className='getdata-info getdata-ready'>
                    <span className='getdata-icon' role='presentation' />
                    <SectionTitle isMobile={isMobile} />
                    <div className='getdata-content'>
                        <div dangerouslySetInnerHTML={{__html: textWithLink}} />
                        {i18n('TakeOut.getdata_available_till')}
                        {` ${archiveInfo.valid}`}
                        <div className='getdata-btns'>
                            {archiveInfo.isPasswordRequired && (
                                <span className='getdata-btn'>
                                    <Button view='pseudo' size='l' type='button' onClick={getArchivePassword}>
                                        {i18n('TakeOut.getdata_showPwd-btn')}
                                    </Button>
                                </span>
                            )}

                            <span className='getdata-btn'>
                                <Button view='pseudo' size='l' type='button' onClick={getArchiveData}>
                                    {i18n('TakeOut.getdata_download')}
                                </Button>
                            </span>
                            <span className='getdata-btn'>
                                <Button view='pseudo' size='l' type='button' onClick={requestDataArchive}>
                                    {i18n('TakeOut.getdata_create_new_archive')}
                                </Button>
                            </span>
                        </div>
                        <Spin size='m' className='getdata-loader' progress={isLoading} />
                    </div>
                    <PasswordModal />
                </div>
            );
        }

        return (
            <div className='getdata-info getdata-info-cols'>
                <span className='getdata-icon' role='presentation' />
                <SectionTitle isMobile={isMobile} />
                <Spin size='m' className='getdata-loader' progress={isLoading} />
                <div className='getdata-content'>
                    <div className='get-data-info__text'>{i18n('TakeOut.getdata_main-descr')}</div>
                    <Button
                        view='pseudo'
                        size='l'
                        type='button'
                        width={isMobile ? 'max' : 'auto'}
                        onClick={requestDataArchive}
                    >
                        {i18n('TakeOut.getdata_make-btn')}
                    </Button>
                </div>
            </div>
        );
    }
}

export default connect(DataInfoContent.mapStateToProps, mapDispatchToProps)(DataInfoContent);

DataInfoContent.propTypes = {
    takeOutInfo: PropTypes.shape({
        status: PropTypes.string.isRequired,
        archivePwd: PropTypes.string,
        isLoading: PropTypes.bool,
        archiveInfo: PropTypes.obj
    }),
    getArchiveData: PropTypes.func.isRequired,
    requestDataArchive: PropTypes.func.isRequired,
    getArchivePassword: PropTypes.func.isRequired,
    isMobile: PropTypes.bool
};
