import React from 'react';
import PropTypes from 'prop-types';
import services from './notArchivedServices';

const NoArchiveServices = ({tld}) => (
    <div className='getdata-no-archive'>
        <h3>{i18n('TakeOut.getdata_no_archive-title')}</h3>
        <div className='getdata-no-archive__descr'>{i18n('TakeOut.getdata_no_archive')}</div>
        <ul className='getdata-no-archive__list'>
            {services.map((item) => (
                <li className={`getdata-no-archive__list-item ${item.id}`} key={item.id}>
                    <div className='getdata-data-descr'>
                        <h4 className='getdata-descr_title'>{item.title}</h4>
                        {item.link && (
                            <p>
                                <a href={item.link.replace('%tld', tld)} target='_blank' rel='noopener noreferrer'>
                                    {i18n('TakeOut.getdata_no_archive-link')}
                                </a>
                            </p>
                        )}
                    </div>
                </li>
            ))}
        </ul>
    </div>
);

export default NoArchiveServices;

NoArchiveServices.propTypes = {
    tld: PropTypes.string.isRequired
};
