import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import mapDispatchToProps from './mapDispatchToProps';
import {Button} from '@components/Button';
import {Modal} from '@components/Modal';
import {Icon} from '@components/IconLego';

class PasswordModal extends Component {
    static mapStateToProps(state) {
        const {takeOutInfo} = state;

        return {
            takeOutInfo
        };
    }

    render() {
        const {togglePasswordVisibility, copyToClipboard, takeOutInfo} = this.props;
        const {isPasswordVisible, archiveInfo = {}, archivePassword, hasPasswordCopied, copyError} = takeOutInfo;
        const passwordNotifyText =
            (hasPasswordCopied && i18n('TakeOut.getdata_pwd_copied')) ||
            (copyError && i18n('TakeOut.getdata_pwd_copied-error'));

        if (!archiveInfo.isPasswordRequired) {
            return null;
        }

        return (
            <Modal visible={isPasswordVisible}>
                <div className='getdata-modal__content'>
                    <span className='getdata-modal__close'>
                        <Button view='clear' onClick={togglePasswordVisibility} size='l'>
                            <Icon glyph='type-cross-websearch' />
                        </Button>
                    </span>
                    <h4 className='getdata-modal__title'>{i18n('TakeOut.getdata_pwd')}</h4>
                    <p>{i18n('TakeOut.getdata_pwd-text')}</p>
                    <div className='getdata-copy__block'>
                        <span className='getdata-copy__btn'>
                            <Button view='pseudo' size='l' onClick={copyToClipboard} type='button'>
                                {i18n('TakeOut.getdata_pwd-copy')}
                            </Button>
                        </span>
                        <div className='symbols-to-copy'>{archivePassword}</div>
                        <span
                            className={classnames('getdata-copy-pwd-notify', {visible: hasPasswordCopied || copyError})}
                        >
                            {passwordNotifyText}
                        </span>
                        <input readOnly='readOnly' id='copied-text' value={archivePassword} />
                    </div>
                </div>
            </Modal>
        );
    }
}

export default connect(PasswordModal.mapStateToProps, mapDispatchToProps)(PasswordModal);

PasswordModal.propTypes = {
    takeOutInfo: PropTypes.shape({
        isPasswordVisible: PropTypes.bool,
        archivePwd: PropTypes.string,
        hasPasswordCopied: PropTypes.bool,
        copyError: PropTypes.string,
        archiveInfo: PropTypes.obj,
        archivePassword: PropTypes.string
    }),
    togglePasswordVisibility: PropTypes.func.isRequired,
    copyToClipboard: PropTypes.func.isRequired
};
