import {combineReducers} from 'redux';
import header from '@blocks/morda/components/header/reducers';
import common from '@blocks/common/reducers';
import domik from '@blocks/morda/components/domik/reducers';
import captcha from '@components/Captcha/reducers';
import {
    UPDATE_TAKEOUT_STATUS,
    TOGGLE_PASSWORD_VISIBILITY,
    UPDATE_TAKEOUT_DATA,
    UPDATE_LOADING_STATUS,
    SET_PASSWORD_LOADING_STATUS,
    SET_LINK_LOADING_STATUS,
    NOTIFY_PASSWORD_COPIED
} from './actions';
import tracks from '@blocks/reducers/tracks';

const stub = (state = {}) => state;
const rootReducer = combineReducers({
    common,
    header,
    access: stub,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    takeOutInfo,
    domik,
    captcha,
    tracks
});

export function takeOutInfo(state = {}, action) {
    switch (action.type) {
        case UPDATE_TAKEOUT_STATUS: {
            return Object.assign({}, state, {
                status: action.status
            });
        }
        case TOGGLE_PASSWORD_VISIBILITY: {
            return Object.assign({}, state, {
                isPasswordVisible: !state.isPasswordVisible
            });
        }
        case UPDATE_TAKEOUT_DATA: {
            return Object.assign({}, state, {
                [action.data.field]: action.data.value
            });
        }
        case SET_PASSWORD_LOADING_STATUS: {
            return Object.assign({}, state, {
                isPasswordLoading: action.isLoading
            });
        }
        case SET_LINK_LOADING_STATUS: {
            return Object.assign({}, state, {
                isLinkLoading: action.isLoading
            });
        }
        case UPDATE_LOADING_STATUS: {
            return Object.assign({}, state, {
                isLoading: !state.isLoading
            });
        }
        case NOTIFY_PASSWORD_COPIED: {
            return Object.assign({}, state, {
                hasPasswordCopied: !state.hasPasswordCopied
            });
        }
        default:
            return state;
    }
}

export default rootReducer;
