(function() {
    var DEFAULT_PROMO = 'promo-browser';
    var ACTIVE_TOGGLER_CLASSNAME = 'active';

    passport.block('promo', {
        events: {
            'click .js-promo-toggler': 'changePromo'
        },

        changePromo: function(event) {
            var promoName = $(event.currentTarget).data('promo');

            if (promoName === this.currentPromo) {
                return;
            }

            this.$promoTogglers.removeClass(ACTIVE_TOGGLER_CLASSNAME);
            $(event.currentTarget).addClass(ACTIVE_TOGGLER_CLASSNAME);
            this.$el.removeClass(this.currentPromo).addClass(promoName);

            this.currentPromo = promoName;
        },

        init: function() {
            this.currentPromo = DEFAULT_PROMO;
            this.$promoTogglers = this.$('.js-promo-toggler');
        }
    });
})();
