import passport from 'pclientjs/js/passport';
export default class AuthorizedBroker {
    constructor() {
        this.yaWindow = null;
        this.defaultParams = {
            startUrl: '/auth/social/start',
            // CLOSER_URL (url на вашу страничку-closer)
            retpath: location.protocol + '//' + location.host + '/auth/i-social__closer.html',
            retnopopup: false,
            consumer: 'passport',
            popupName: 'social_passport',
            display: 'popup',
            place: 'fragment'
        };
    }

    isClosed() {
        let closed;
        // старые андроиды возвращают undefined в случае, если окно закрыто

        if (!this.yaWindow || (this.yaWindow && typeof this.yaWindow.closed === 'undefined')) {
            return true;
        }

        try {
            closed = this.yaWindow.closed;
        } catch (error) {
            closed = true;
        }

        return closed;
    }

    open(paramsOverride) {
        const self = this;
        const width = 650;
        const height = 400;
        // eslint-disable-next-line compat/compat
        const left = Math.round(((window.opera ? window.innerWidth : screen.availWidth) - width) / 2);
        // eslint-disable-next-line compat/compat
        const top = Math.round(((window.opera ? window.innerHeight : screen.availHeight) - height) / 2);
        const popupProperties =
            'scrollbars=yes, resizable=1, menubar=0, toolbar=0, status=0, location=0, ' +
            'directories=0, left=' +
            left +
            ', top=' +
            top +
            ', width=' +
            width +
            ', height=' +
            height;
        const requestParams = {};

        let currentWindow = false;

        let currentUrlWithoutUid;

        let urlParams;

        let query;

        let url = this.url;

        let callbackParams;

        Object.keys(this.defaultParams).forEach(function(key) {
            requestParams[key] = self.defaultParams[key];
        });

        [].concat(Object.keys(paramsOverride)).forEach(function(key) {
            requestParams[key] = paramsOverride[key];
        });

        if ((requestParams.display && requestParams.display !== 'popup') || requestParams.currentWindow) {
            urlParams = passport.util.getUrlParams(window.location.href);
            delete urlParams.uid;
            query = Object.keys(urlParams)
                .map(function(param) {
                    return param + '=' + urlParams[param];
                })
                .join('&');
            currentUrlWithoutUid =
                'https://' + window.location.hostname + window.location.pathname + (query ? '?' : '') + query;
            requestParams.retpath = requestParams.retnopopup || currentUrlWithoutUid;
            //requestParams.retpath = requestParams.retnopopup || window.location.href;
            currentWindow = true;
        } else {
            callbackParams =
                'ddom=' + (requestParams.ddom || (location.hostname === document.domain ? '' : document.domain));
            requestParams.retpath += (requestParams.retpath.match('#') ? '&' : '#') + callbackParams;

            if ('retnopopup' in requestParams) {
                delete requestParams.retnopopup;
            }
        }

        Object.keys(requestParams).forEach(function(key, index) {
            url += index === 0 ? '?' : '&';
            url += encodeURIComponent(key) + '=' + encodeURIComponent(requestParams[key]);
        });

        if (currentWindow) {
            window.location.href = url;
            return;
        }

        this.yaWindow = window.open(url, this.popupName, popupProperties);

        if (this.yaWindow) {
            this.yaWindow.focus();
        }
    }

    cleanup() {
        if (!this.isClosed()) {
            this.yaWindow.close();
        }

        this.yaWindow = null;
    }

    start(paramsOverride) {
        this.cleanup();
        this.open(paramsOverride);
    }

    init(params) {
        this.defaultParams = $.extend(this.defaultParams, params || {});
        this.url = this.defaultParams.startUrl;
        delete this.defaultParams.startUrl;
    }
}
