/* global module */

(function(global, factory) {
    'use strict';

    if (typeof module === 'object' && module.exports) {
        module.exports = factory(require('pclientjs/js/block'));
    } else {
        factory(global.passport);
    }
})(this, function(passport) {
    'use strict';

    function merge() {
        var obj;
        var result = {};

        for (var i = 0; i < arguments.length; i++) {
            obj = arguments[i];

            if (typeof obj === 'object' && obj) {
                for (var key in obj) {
                    if (obj.hasOwnProperty(key)) {
                        result[key] = obj[key];
                    }
                }
            }
        }

        return result;
    }

    function keys(obj) {
        var keys = [];

        if (typeof obj === 'object' && obj) {
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    keys.push(key);
                }
            }
        }

        return keys;
    }

    function map(arr, cb) {
        var result = [];

        if (typeof cb === 'function' && typeof arr === 'object' && arr.length) {
            for (var i = 0; i < arr.length; i++) {
                result.push(cb(arr[i], i, arr));
            }
        }

        return result;
    }

    if (typeof window !== 'object') {
        return {};
    }

    return passport.block('broker', {
        yaWindow: null,
        defaultParams: {
            startUrl: '/auth/social/start',
            // CLOSER_URL (url на вашу страничку-closer)
            retpath: location.protocol + '//' + location.host + '/auth/i-social__closer.html',
            retnopopup: false,
            consumer: 'passport',
            popupName: 'social_passport',
            display: 'popup',
            place: 'fragment'
        },

        isClosed: function() {
            var closed;
            // старые андроиды возвращают undefined в случае, если окно закрыто

            if (!this.yaWindow || (this.yaWindow && typeof this.yaWindow.closed === 'undefined')) {
                return true;
            }

            try {
                closed = this.yaWindow.closed;
            } catch (error) {
                closed = true;
            }

            return closed;
        },

        open: function(paramsOverride) {
            var width = 650;
            var height = 370;
            // eslint-disable-next-line compat/compat
            var left = Math.round(((window.opera ? window.innerWidth : screen.availWidth) - width) / 2);
            // eslint-disable-next-line compat/compat
            var top = Math.round(((window.opera ? window.innerHeight : screen.availHeight) - height) / 2);
            var popupProperties =
                'scrollbars=yes, resizable=1, menubar=0, toolbar=0, status=0, location=0, ' +
                'directories=0, left=' +
                left +
                ', top=' +
                top +
                ', width=' +
                width +
                ', height=' +
                height;
            var currentWindow = false;
            var requestParams = merge(this.defaultParams, paramsOverride);
            var currentUrlWithoutUid;
            var urlParams;
            var query;
            var url = this.url;
            var callbackParams;

            if ((requestParams.display && requestParams.display !== 'popup') || requestParams.currentWindow) {
                urlParams = passport.util.getUrlParams(window.location.href);
                delete urlParams.uid;
                query = map(keys(urlParams), function(param) {
                    return param + '=' + urlParams[param];
                }).join('&');
                currentUrlWithoutUid =
                    'https://' + window.location.hostname + window.location.pathname + (query ? '?' : '') + query;
                requestParams.retpath = requestParams.retnopopup || currentUrlWithoutUid;
                //requestParams.retpath = requestParams.retnopopup || window.location.href;
                currentWindow = true;
            } else {
                callbackParams =
                    'ddom=' + (requestParams.ddom || (location.hostname === document.domain ? '' : document.domain));
                requestParams.retpath += (requestParams.retpath.match('#') ? '&' : '#') + callbackParams;

                if ('retnopopup' in requestParams) {
                    delete requestParams.retnopopup;
                }
            }

            url +=
                '?' +
                map(keys(requestParams), function(key) {
                    return encodeURIComponent(key) + '=' + encodeURIComponent(requestParams[key]);
                }).join('&');

            if (currentWindow) {
                window.location.href = url;
                return;
            }

            this.yaWindow = window.open(url, this.popupName, popupProperties);

            if (this.yaWindow) {
                this.yaWindow.focus();
            }
        },

        cleanup: function() {
            if (!this.isClosed()) {
                this.yaWindow.close();
            }

            this.yaWindow = null;
        },

        start: function(paramsOverride) {
            this.cleanup();
            this.open(paramsOverride);
        },

        init: function(params) {
            this.defaultParams = params ? merge(this.defaultParams, params) : this.defaultParams;
            this.url = this.defaultParams.startUrl;
            delete this.defaultParams.startUrl;
        }
    });
});
