/* global nb, yr */

/* borschik:include:./log_user_actions.js */

(function() {
    'use strict';

    var exports = {};
    var locals = {};
    var headerMetrics = ['Телефонные номера'];

    function sendMetric(params) {
        if (headerMetrics) {
            passport.Metrika.count(headerMetrics.concat(params));
        }
    }

    $('.js-yasms-replace-cancel').click(function() {
        passport.block('yasms').hideReplaceOperationNotify();
    });

    $('.js-yasms-replace-ok').click(function() {
        nb.block($('.js-yasms-info-popup').get(0)).close();
        passport.block('yasms').showReplaceState();
    });

    $('.js-yasms-delete-ok').click(function() {
        nb.block($('.js-yasms-info-popup').get(0)).close();
        passport.block('yasms').showRemoveState();
    });

    /* borschik:include:../../routes/common/yasmsStateParser.js */

    passport.block('yasms', {
        view: 'profile.phones',
        switchTemplate: 'phone-form',
        resendTimeout: 30,
        errorPopupHow: {
            at: 'top',
            my: 'bottom'
        },

        operation: {
            id: null,
            step: null,
            type: null,
            phone: null,
            phoneId: null,
            phoneIdReplaced: null,
            quarantine: null
        },

        phoneType: 'secure',
        state: 'default',
        operationReplaceEntryIndex: '-1',
        fields: {},

        canSwitchInputType: true,

        events: {
            'submit .js-edit-form': 'preventSubmit',
            'correct.captcha': 'proceedCaptcha',
            'incorrect.captcha': 'proceedCaptchaError',
            'click .js-yasms-add': 'operationBind',
            'click .js-yasms-remove': 'operationRemove',
            'click .js-yasms-replace': 'operationReplace',
            'click .js-yasms-confirm': 'operationConfirm',
            'click .js-yasms-prolong': 'operationProlong',
            'click .js-yasms-confirm-sms2fa': 'checkCodeAndToggleSms2fa',
            'click .js-yasms-cancel': 'operationCancel',
            'click .js-yasms-notify': 'setDefaultForNotify',
            'click .js-yasms-resend-code': 'resendCode',
            'click .js-yasms-replace-show': 'showReplaceState',
            'click .js-yasms-alias-replace-show': 'showReplaceOperationNotify',
            'touchstart .js-yasms-replace-show': 'showReplaceState',
            'click .js-yasms-remove-show': 'showRemoveState',
            'click .js-yasms-alias-remove-show': 'showReplaceOperationNotify',
            'touchstart .js-yasms-remove-show': 'showRemoveState',
            'click .js-password-toggle-visibility': 'togglePasswordVisibility'
        },

        getLocals: function() {
            return locals;
        },

        getSecure: function() {
            return locals.secure || {};
        },

        getSimple: function() {
            return locals.simple || [];
        },

        setLocals: function(data) {
            locals = $.extend({}, locals, data);
        },

        clearLocals: function() {
            this.setLocals({
                secure: {},
                simple: []
            });
        },

        preventSubmit: function(event) {
            if (event) {
                event.preventDefault();
            }
        },

        getControl: function(name) {
            return this.fields[name] || null;
        },

        setControl: function(name, control) {
            this.fields[name] = control;
        },

        clearControls: function() {
            var block;

            if (!Object.keys(this.fields).length) {
                return;
            }

            for (block in this.fields) {
                if (this.fields[block] && typeof this.fields[block].destroy === 'function') {
                    this.fields[block].destroy();
                }
            }

            this.fields = {};
        },

        bindControls: function() {
            var phoneField;
            var phonesField;
            var codeField;
            var passwordField;
            var ownerField;
            var aliasField;
            var aliasAsEmailField;
            var sms2faField;

            this.clearControls();
            phoneField = this.$('#yasms-number-secure').get(0);
            phonesField = this.$('#yasms-numbers-secure').get(0);
            codeField = this.$('#yasms-code-secure').get(0);
            passwordField = this.$('#yasms-password-secure').get(0);
            ownerField = this.$('#yasms-owner-secure').get(0);
            aliasField = this.$('#yasms-alias-secure').get(0);
            aliasAsEmailField = this.$('#yasms-alias-as-email').get(0);
            sms2faField = this.$('#js-yasms-sms2fa').get(0);

            if (phoneField) {
                this.setControl('number', nb.block(phoneField));
            }

            if (phonesField) {
                this.setControl('numbers', nb.block(phonesField));
                this.getControl('numbers').on('nb-changed', this.showPhoneEntry.bind(this));
            }

            if (codeField) {
                this.setControl('code', nb.block(codeField));
            }

            if (passwordField) {
                this.setControl('password', nb.block(passwordField));
            }

            if (ownerField) {
                this.setControl('owner', nb.block(ownerField));
            }

            if (aliasField) {
                this.setControl('alias', nb.block(aliasField));
                this.getControl('alias').on('nb-changed', this.operationAlias.bind(this));
            }

            if (aliasAsEmailField) {
                this.setControl('alias-as-email', nb.block(aliasAsEmailField));
                this.getControl('alias-as-email').on('nb-changed', this.operationAliasAsEmail.bind(this));
            }

            if (sms2faField) {
                this.setControl('sms2fa', nb.block(sms2faField));
                this.getControl('sms2fa').on('nb-changed', this.operationSms2fa.bind(this));
            }

            this.form = this.$('.js-secure-phone-form');
        },

        authErrors: ['account.not_found', 'sessionid.invalid', 'account.disabled', 'account.disabled_on_deletion'],

        processError: function(errors, control) {
            var _errors = {
                internal: i18n('%phones.errors.internal'), // eslint-disable-line
                'number.empty': i18n('%phones.errors.phone.empty'),
                'number.invalid': i18n('%phones.errors.phone.invalid'),
                'numbers.empty': i18n('%phones.errors.phones.empty'),
                'number.is_secure': i18n('%phones.errors.phone.issecure'),
                'current_password.empty': i18n('%phones.errors.password.empty'),
                'password.not_matched': i18n('%phones.errors.password.invalid'),
                'code.invalid': i18n('%phones.errors.code.invalid'),
                'code.empty': i18n('%phones.errors.code.empty'),
                'sms_limit.exceeded': i18n('%phones.errors.limit-exceeded'),
                'confirmations_limit.exceeded': i18n('%phones.errors.confirmation-limit-exceeded'),
                'phone.bound': i18n('%phones.errors.phone.bound'),
                'phone.compromised': i18n('%phone-confirm_errors_compromised'),
                'phone.blocked': i18n('%phones.errors.phone.blocked'),
                'operation.exists': i18n('%phones.errors.operation.exists'),
                'phone_secure.already_exists': i18n('%phones.errors.secure.exists'),
                'phone_secure.not_found': i18n('%phones.errors.secure.notfound'),
                'operation.secure_operation_exists': i18n('%phones.errors.operation.secure.exists'),
                'account.invalid_type': i18n('%phones.errors.account.invalidtype'),
                'account.2fa_enabled': i18n('%phones.errors.account.invalidtype'),
                'upgrade.neophonish': i18n(
                    '%phones.errors.upgrade.neophonish',
                    '<a href="/profile/upgrade" target="_blank">',
                    '</a>'
                )
            };
            var self = this;
            var fieldName;
            var error;
            var field;
            var code;
            var pair;

            if (errors.length === 0) {
                return;
            }

            if (errors.indexOf('operation.not_found') !== -1) {
                this.getState().done(function() {
                    self.repaintBlocks();
                });

                return;
            }

            if (errors === 'captcha.required' || (Array.isArray(errors) && errors.indexOf('captcha.required') !== -1)) {
                this.enableCaptcha();
                return;
            }

            if (Array.isArray(errors)) {
                code = errors.shift();
            } else {
                code = errors;
            }

            if (this.authErrors.indexOf(code) !== -1) {
                this.goToAuth();
                return;
            }

            error = _errors[code] || _errors.internal;

            if (!error) {
                return;
            }

            if (control) {
                field = control;
            } else {
                pair = code.split('.');
                fieldName = pair && pair[0];
                field = fieldName && this.getControl(fieldName);
            }

            if (!field) {
                return;
            }

            if (typeof field.showError === 'function') {
                var codeWithoutDot = typeof code === 'string' ? code.replace('.', '_') : 'unknown_error';

                field.showError({
                    autoclose: true,
                    content: error,
                    how: this.errorPopupHow,
                    class: 't-error-popup-' + codeWithoutDot
                });

                return;
            }

            if (field.target || field.$node) {
                this.errorPopup.setContent(error).open({
                    where: field.target || field.$node,
                    how: this.errorPopupHow
                });
            }
        },

        goToAuth: function() {
            location.href = '//' + location.host + '/auth?retpath=' + encodeURIComponent(location.href);
        },

        fixPopups: function() {
            $(window).emit('resize'); // хак для смещения попапов с ошибками
        },

        hideResendTimer: function() {
            this.$('.js-yasms-resend-code, .js-resend-code-timer-wrap').remove();
            clearInterval(this.timer);
            this.fixPopups();
        },

        startResendTimer: function() {
            var timerBox = this.$('.js-resend-code-timer-wrap');
            var timerText = this.$('.js-resend-code-timer');
            var resendLink = this.$('.js-yasms-resend-code');
            var seconds = this.resendTimeout;
            var self = this;

            resendLink.addClass('g-hidden');
            timerBox.removeClass('g-hidden');
            timerText.text(seconds);

            this.timer = setInterval(function() {
                --seconds;

                if (seconds === 0) {
                    resendLink.removeClass('g-hidden');
                    timerBox.addClass('g-hidden');
                    clearInterval(self.timer);
                    self.fixPopups();
                } else {
                    timerText.text(seconds < 10 ? '0' + seconds : seconds);
                }
            }, 1000);
        },

        switchState: function(state, silent, clearTimer) {
            var isOperationConfirm = false;
            var secure = this.getSecure();
            var data = $.extend({}, this.getLocals(), {
                phoneType: this.phoneType || '',
                operationType: this.operation.type || '',
                operationPhone: this.operation.phone || '',
                canSwitchInputType: this.canSwitchInputType,
                owner: secure && secure.owner
            });

            if (state) {
                data.state = state;
                isOperationConfirm =
                    ['confirm', 'confirm-simple', 'securify', 'sms2faOn', 'sms2faOff'].indexOf(state) !== -1;
                this.disableControls();
                this.state = state;
            }

            this.form.html(yr.run(this.view, data, this.switchTemplate));

            if (state !== 'replace' && state !== 'remove') {
                this.$('input:visible')
                    .first()
                    .focus();
            }

            $('[data-esec-id]').remove();

            if (!silent) {
                this.bindControls();
            }

            if (isOperationConfirm && !clearTimer) {
                this.startResendTimer();
            }
        },

        disableControls: function() {
            $('.js-yasms-secure-controls .yasms-control-button')
                .add('.js-yasms-simple-control .yasms-control-button')
                .add('.js-yasms-show-add-form, .js-yasms-alias, .js-yasms-alias-as-email, .js-yasms-sms2fa')
                .each(function() {
                    var block = nb.block(this); // eslint-disable-line no-invalid-this

                    if (block && typeof block.disable === 'function') {
                        block.disable();
                    } else {
                        $(this).addClass('is-disable'); // eslint-disable-line no-invalid-this
                    }
                });
        },

        enableControls: function() {
            $('.js-yasms-secure-controls .yasms-control-button')
                .add('.js-yasms-simple-control .yasms-control-button')
                .add('.js-yasms-show-add-form, .js-yasms-alias, .js-yasms-alias-as-email, .js-yasms-sms2fa')
                .each(function() {
                    var block = nb.block(this); // eslint-disable-line no-invalid-this

                    if (block && typeof block.enable === 'function') {
                        block.enable();
                    } else {
                        $(this).removeClass('is-disable'); // eslint-disable-line no-invalid-this
                    }
                });
        },

        repaintBlock: function() {
            this.setDefaultState();
            this.$('.js-yasms-secure-phone').html(yr.run(this.view, this.getLocals(), 'secure-phone-inner'));
            $('[data-esec-id]').remove();
            this.bindControls();
        },

        repaintBlocks: function() {
            this.toggleYasmsSimpleVisible();

            passport.block('yasms').repaintBlock();
            passport.block('yasms-simple').repaintBlock();
        },

        toggleYasmsSimpleVisible: function() {
            var locals = this.getLocals();

            if (locals.isSocialchik && !locals.isShowPhonesForNonPasswordExp) {
                return;
            }

            $('.js-yasms-simple').toggleClass('g-hidden', !locals.secure.number && locals.simple.length === 0);
        },

        showReplaceState: function(event) {
            var locals = this.getLocals();

            if (locals.isNeoPhonish) {
                return this.processError(['upgrade.neophonish'], event);
            }

            this.switchState('replace');
            this.scrollToStateBlock(event);
        },

        showRemoveState: function(event) {
            var locals = this.getLocals();

            if (locals.isNeoPhonish) {
                return this.processError(['upgrade.neophonish'], event);
            }

            this.switchState('remove');
            this.scrollToStateBlock(event);
        },

        scrollToStateBlock: function(event) {
            if (!event) {
                return;
            }

            if (event.type !== 'touchstart' && event.type !== 'click') {
                return;
            }

            event.preventDefault();
            event.stopPropagation();

            var stateBlock = $('.yasms-phone-edit input:visible').first();

            if (!stateBlock) {
                return;
            }

            if (event.type === 'touchstart') {
                var elemPosition = stateBlock.offset().top;

                window.scrollTo(0, elemPosition);
            }

            if (event.type === 'click') {
                stateBlock.focus();
            }
        },

        showPhoneEntry: function() {
            var phonesField = this.getControl('numbers');
            var phonesFieldState = phonesField.getState();

            this.$('.js-yasms-number').toggleClass(
                'g-hidden',
                phonesFieldState && phonesFieldState.value !== this.operationReplaceEntryIndex
            );
        },

        showReplaceOperationNotify: function(event) {
            var locals = this.getLocals();
            var operationType = event.currentTarget.dataset && event.currentTarget.dataset.operation;
            var maskedPhone = locals.secure.number + '@yandex.' + locals.domain;

            $('.js-yasms-warning-number').text(maskedPhone);
            $('.yasms-notify-button').addClass('g-hidden');
            $('.js-yasms-' + operationType + '-ok').removeClass('g-hidden');
            nb.block($('.js-yasms-info-popup').get(0)).open();
        },

        hideReplaceOperationNotify: function() {
            nb.block($('.js-yasms-info-popup').get(0)).close();
        },

        successOperationNotify: function() {
            var phone;
            var locals = this.getLocals();
            var data = {
                number: this.operation.phone,
                operationType: this.operation.type,
                isQuarantine: this.operation.quarantine,
                isSocialchik: locals.isSocialchik
            };

            if (this.operation.quarantine) {
                if (this.phoneType) {
                    phone = this.getSecure();
                } else {
                    phone = this.yasmsSimple.getPhoneById(this.operation.phoneId);
                }

                data.quarantineEnd = phone.quarantineEnd;
            }

            if (
                data.operationType === 'alias-as-email-enable' ||
                data.operationType === 'alias-as-email-disable' ||
                data.operationType === 'aliasify'
            ) {
                data.tld = $('body').data('tld') || 'ru';

                if (data.number.charAt(0) === '+') {
                    data.digitalNumber = data.number.slice(1).trim();
                }
            }

            $('.js-yasms-notify').html(yr.run(this.view, data, 'popup'));

            nb.block($('.js-yasms-popup').get(0)).open();

            if (passport.isTouch && !passport.isTablet) {
                $('.js-yasms-popup').addClass('yasms-operation-popup__visible');
            }
        },

        setReplacedPhone: function(id) {
            var field = this.getControl('numbers');

            if (!id) {
                return;
            }

            if (field) {
                field.setState({value: id});
            }
        },

        toggleSpinner: function(hide, $spinner) {
            var $formSpin = this.$('.js-yasms-phone-edit-spinner');
            var $controlSpin = this.$('.js-yasms-secure-controls-spinner');
            var method = 'removeClass';

            if (hide) {
                method = 'addClass';
            }

            if ($spinner) {
                $spinner[method]('g-hidden');
                return;
            }

            if (this.state === 'default') {
                $controlSpin[method]('g-hidden');
            } else {
                $formSpin[method]('g-hidden');
            }
        },

        updateLocals: function(data) {
            if (!data) {
                return;
            }

            this.clearLocals();
            this.setLocals($.extend({}, this.getLocals(), exports.parse(data)));
        },

        setDefaultState: function() {
            var secure = this.getSecure();

            this.clearOperationParams();
            this.state = 'default';

            if (secure && secure.operation && secure.operation.id) {
                this.operation = $.extend({}, this.operation, secure.operation);

                if (!secure.quarantine) {
                    this.state = this.operation.step || 'confirm';
                }
            }
        },

        getState: function() {
            var def = new $.Deferred();
            var self = this;

            passport.api.request('yasms.state', {}).done(function(response) {
                if (response.status === 'ok') {
                    self.updateLocals(response.account);
                    def.resolve({status: 'ok'});
                    return;
                }

                def.reject(response.errors);
            });

            return def.promise();
        },

        updateState: function(event) {
            var self = this;

            this.getState()
                .done(function() {
                    if (self.operation.type) {
                        self.successOperationNotify();
                    }

                    self.repaintBlocks();
                })
                .fail(function() {
                    self.processError('internal', event);
                });
        },

        operationBind: function(event) {
            var self = this;
            var field = this.getControl('number');
            var fieldAlias = this.getControl('alias');
            var number = (field && field.getValue()) || '';
            var YsaLogger = window.YsaLogger;

            this.operation.type = 'bind';
            if (!number.trim()) {
                this.processError('number.empty', field);
                return;
            }

            this.toggleSpinner();
            YsaLogger.flushAllEvents();
            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type + '.submit', {
                    ysaNamespace: YsaLogger.ysaNamespace,
                    ysaEsecId: YsaLogger.ysaEsecId,
                    aliasify: fieldAlias && fieldAlias.isChecked(),
                    number: number
                })
                .done(function(response) {
                    var operation = response.operation || null;

                    if (response.status === 'error') {
                        self.toggleSpinner(true);
                        self.processError(response.errors, field);
                        return;
                    }

                    if (!operation) {
                        return;
                    }

                    self.operation = $.extend(self.operation, operation);
                    self.switchState('confirm');
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true);
                });

            sendMetric(['Начать привязку телефона']);
        },

        operationRemove: function(event) {
            var ownerField = this.getControl('owner');
            var self = this;
            var data = {
                owner: ownerField && ownerField.isChecked() ? 1 : 0
            };

            this.operation.type = 'remove';
            this.toggleSpinner();
            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type + '.submit', data)
                .done(function(response) {
                    var operation = response.operation || null;

                    if (response.status === 'error') {
                        self.toggleSpinner(true);
                        self.processError(response.errors, event);
                        return;
                    }

                    if (!operation) {
                        return;
                    }

                    self.operation = $.extend(self.operation, operation, {
                        quarantine: !data.owner
                    });

                    locals.secure.owner = data.owner;
                    self.switchState('confirm');
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true);
                });
        },

        operationReplace: function(event) {
            var ownerField = this.getControl('owner');
            var phoneField = this.getControl('number');
            var phonesField = this.getControl('numbers');
            var phonesFieldState = (phonesField && phonesField.getState()) || {};
            var self = this;
            var data = {
                owner: ownerField && ownerField.isChecked() ? 1 : 0
            };

            this.operation.type = 'replace';

            if (!phonesField || phonesFieldState.value === this.operationReplaceEntryIndex) {
                data.number = phoneField && phoneField.getValue();

                if (!data.number) {
                    this.processError('number.empty', phoneField);
                    return;
                }
            } else {
                data.phone_id = phonesFieldState.value;

                if (!data.phone_id) {
                    this.processError('numbers.empty', phonesField);
                    return;
                }
            }

            this.toggleSpinner();
            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type + '.submit', data)
                .done(function(response) {
                    var phone;

                    if (response.status === 'error') {
                        self.toggleSpinner(true);

                        if (response.errors.indexOf('action.not_required') !== -1) {
                            response.errors = ['number.is_secure'];
                        }

                        if (data.number) {
                            self.processError(response.errors, phoneField);
                        } else if (data.phone_id) {
                            self.processError(response.errors, phonesField);
                        } else {
                            self.processError(response.errors, event);
                        }

                        return;
                    }

                    phone = data.owner ? response.secure_phone : response.simple_phone;

                    if (!phone) {
                        return;
                    }

                    self.operation.id = phone.operation && phone.operation.id;
                    self.operation.phone = phone.number;
                    self.operation.phoneId = phone.id;
                    self.operation.phoneIdReplaced = response.simple_phone.id;
                    self.operation.quarantine = !data.owner;
                    locals.secure.owner = data.owner;

                    self.switchState('confirm');
                    self.operation.step = data.owner ? 'confirm-secure' : 'confirm-simple';
                    self.yasmsSimple.markPhone(response.simple_phone);
                    self.yasmsSimple.repaintPhonesList();
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true);
                });

            sendMetric(['Начать замену телефона']);
        },

        operationAlias: function() {
            var self = this;
            var secure = this.getSecure();
            var field = this.getControl('alias');
            var aliasAsEmailField = this.getControl('alias-as-email');
            var isChecked = field.isChecked();
            var isAliasAsEmailFieldChecked = false;

            if (secure.id === undefined) {
                return;
            }

            if (!field) {
                return;
            }

            field.disable();

            this.operation.type = isChecked ? 'aliasify' : 'dealiasify';

            if (aliasAsEmailField) {
                isAliasAsEmailFieldChecked = aliasAsEmailField.isChecked();

                if (isAliasAsEmailFieldChecked && !isChecked) {
                    aliasAsEmailField.uncheck();
                }

                aliasAsEmailField.disable();
            }

            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type + '.submit', {})
                .done(function(response) {
                    var operation = response.operation || null;

                    if (response.status === 'error') {
                        self.processError(response.errors, field);

                        field.enable();

                        if (aliasAsEmailField) {
                            aliasAsEmailField.enable();

                            if (isAliasAsEmailFieldChecked) {
                                aliasAsEmailField.check();
                            }
                        }

                        if (isChecked) {
                            field.uncheck();
                        } else {
                            field.check();

                            if (aliasAsEmailField) {
                                aliasAsEmailField.check();
                            }
                        }

                        return;
                    }

                    if (!operation) {
                        return;
                    }

                    self.operation = $.extend(self.operation, operation);
                    self.switchState('confirm');
                })
                .fail(function() {
                    self.processError('internal', field);

                    field.enable();

                    if (aliasAsEmailField) {
                        aliasAsEmailField.enable();

                        if (isAliasAsEmailFieldChecked) {
                            aliasAsEmailField.check();
                        }
                    }

                    if (isChecked) {
                        field.uncheck();
                    } else {
                        field.check();

                        if (aliasAsEmailField && isAliasAsEmailFieldChecked) {
                            aliasAsEmailField.check();
                        }
                    }
                });

            sendMetric(['Использовать номер телефона как логин: ' + (isChecked ? 'включить' : 'выключить')]);
        },

        operationAliasAsEmail: function() {
            var self = this;
            var secure = this.getSecure();
            var field = this.getControl('alias-as-email');
            var isChecked = field.isChecked();

            if (secure.id === undefined) {
                return;
            }

            if (!field) {
                return;
            }

            field.disable();

            var handleMethod = isChecked ? 'enable' : 'disable';

            this.operation = {
                phone: secure.number,
                type: 'alias-as-email-' + handleMethod,
                quarantine: false
            };

            passport.api
                .request('yasms.alias.as.email.' + handleMethod, {})
                .done(function(response) {
                    if (response.status === 'error') {
                        self.processError(response.errors, field);

                        field.enable();
                        if (isChecked) {
                            field.uncheck();
                        } else {
                            field.check();
                        }

                        return;
                    }

                    field.enable();

                    self.getState().done(function() {
                        self.successOperationNotify();
                        self.repaintBlocks();
                    });
                })
                .fail(function() {
                    self.processError('internal', field);

                    field.enable();
                    if (isChecked) {
                        field.uncheck();
                    } else {
                        field.check();
                    }
                });

            sendMetric(['Использовать номер телефона как почту: ' + (isChecked ? 'включить' : 'выключить')]);
        },

        operationSms2fa: function() {
            var field = this.getControl('sms2fa');
            var codeField = this.getControl('code');
            var isChecked = field.isChecked();
            var secure = this.getSecure();
            var self = this;

            if (secure.id === undefined) {
                return;
            }

            if (!field) {
                return;
            }

            field.disable();

            this.operation.type = isChecked ? 'sms2faOn' : 'sms2faOff';
            this.operation.phone = secure.number;

            passport.api
                .request('phone-confirm-code-submit', {phone_id: secure.id, isCodeWithFormat: true}) // no AM here
                .done(function(response) {
                    if (response.status === 'error') {
                        self.processError(response.errors, field);
                        field.enable();
                        isChecked ? field.uncheck() : field.check();
                        return;
                    }

                    self.switchState(isChecked ? 'sms2faOn' : 'sms2faOff');
                })
                .fail(function(error) {
                    self.processError(error, codeField);
                    field.enable();
                    if (isChecked) {
                        field.uncheck();
                    } else {
                        field.check();
                    }
                });
        },

        checkCodeAndToggleSms2fa: function() {
            var state = this.state;
            var field = this.getControl('code');
            var code = (field && field.getValue()) || '';
            var self = this;

            passport.api
                .request('yasms.sms2fa', {code: code, isEnabled: state === 'sms2faOn' ? 'yes' : 'no'})
                .done(function(response) {
                    if (response.status === 'ok') {
                        self.successOperationNotify();
                        self.setLocals({isSms2FAOn: state === 'sms2faOn'});
                        passport.api.getTrackId(undefined, true);
                        self.repaintBlocks();

                        sendMetric([
                            'Безопасный вход с подтверждением по телефону ' +
                                (state === 'sms2faOn' ? 'включить' : 'выключить')
                        ]);
                        return;
                    }

                    self.processError(response.errors || 'internal', field);
                })
                .fail(function() {
                    self.processError('internal', field);
                });
        },

        operationConfirm: function(event) {
            var self = this;
            var handles = [];
            var secure = this.getSecure();

            if (this.phoneType === 'simple') {
                handles.push(this.checkCode());

                if (
                    this.operation.type === 'securify' &&
                    !(locals.isSocialchik && locals.isShowPhonesForNonPasswordExp)
                ) {
                    handles.push(this.checkPassword());
                }
            }

            if (this.phoneType === 'secure') {
                if (
                    ['remove', 'dealiasify'].indexOf(this.operation.type) === -1 ||
                    (this.operation.type === 'remove' && secure.owner)
                ) {
                    handles.push(this.checkCode());
                }

                if (
                    this.operation.type !== 'aliasify' &&
                    !(locals.isSocialchik && locals.isShowPhonesForNonPasswordExp)
                ) {
                    if (!this.operation.step || this.operation.step !== 'confirm-simple') {
                        handles.push(this.checkPassword());
                    }

                    if (this.operation.step === 'confirm-simple' && !secure.owner) {
                        handles.push(this.checkPassword());
                    }
                }
            }

            this.toggleSpinner();
            window.YsaLogger.flushAllEvents();
            $.when.apply($, handles).then(
                function() {
                    if (self.operation.type === 'replace' && self.operation.step === 'confirm-secure') {
                        self.operationReplaceParams();
                        self.switchState('confirm-simple', null, true);
                        return;
                    }

                    self.operationCommit(event);
                },
                function() {
                    self.toggleSpinner(true);
                }
            );

            sendMetric(['Подтверждение операции кодом и/или паролем']);
        },

        operationCommit: function(event) {
            var self = this;
            var sms2faField = this.getControl('sms2fa');
            var isSms2faToggle =
                self.phoneType === 'secure' && self.operation.type === 'bind' && sms2faField && sms2faField.isChecked();
            var params = {
                id: this.operation.id
            };

            if (isSms2faToggle) {
                params.isSms2fa = isSms2faToggle;
            }

            window.YsaLogger.flushAllEvents();
            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type + '.commit', params)
                .done(function(response) {
                    if (response.status === 'error') {
                        self.toggleSpinner(true);
                        self.processError(response.errors, event);
                        return;
                    }

                    passport.api.log(['yasms', self.operation.type, self.phoneType].join(' '));
                    passport.api.getTrackId(undefined, true);
                    self.updateState(event);

                    if (isSms2faToggle) {
                        self.setLocals({isSms2FAOn: true});
                    }
                })
                .fail(function() {
                    self.processError('internal', event);
                });
        },

        checkPassword: function() {
            var self = this;
            var def = new $.Deferred();

            var field = this.getControl('password');
            var password = (field && field.getValue()) || '';

            if (!password.trim()) {
                this.processError('current_password.empty', field);
                return def.reject();
            }

            passport.api
                .request('yasms.password.check', {
                    operationId: this.operation.id,
                    password: password
                })
                .done(function(response) {
                    if (response.status === 'error' && response.errors.indexOf('action.not_required') === -1) {
                        self.toggleSpinner(true);
                        self.processError(response.errors, field);
                        return def.reject(response);
                    }

                    field.hideError();
                    return def.resolve({status: 'ok'});
                })
                .fail(function() {
                    self.processError('internal', field);
                    self.toggleSpinner(true);
                });

            return def.promise();
        },

        checkCode: function() {
            var self = this;
            var def = new $.Deferred();
            var field = this.getControl('code');
            var code = (field && field.getValue()) || '';

            if (!code.trim()) {
                this.processError('code.empty', field);
                return def.reject();
            }

            passport.api
                .request('yasms.code.check', {
                    operationId: this.operation.id,
                    code: code
                })
                .done(function(response) {
                    if (response.status === 'error' && response.errors.indexOf('action.not_required') === -1) {
                        self.toggleSpinner(true);
                        self.processError(response.errors, field);
                        return def.reject(response);
                    }

                    field.hideError();
                    self.hideResendTimer();
                    return def.resolve({status: 'ok'});
                })
                .fail(function() {
                    self.processError('internal', field);
                    self.toggleSpinner(true);
                });

            return def.promise();
        },

        resendCode: function(event) {
            var self = this;
            var codeField = this.getControl('code');
            var operation = this.operation.type;

            if (operation === 'sms2faOn' || operation === 'sms2faOff') {
                this.operationSms2fa();
                return;
            }

            this.toggleSpinner();
            passport.api
                .request('yasms.code.resend', {
                    id: this.operation.id
                })
                .done(function(response) {
                    self.toggleSpinner(true);

                    if (response.status === 'error') {
                        if (response.errors.indexOf('phone.confirmed') === -1) {
                            self.processError(response.errors, event);
                        }

                        return;
                    }

                    codeField.reset();
                    self.startResendTimer();
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true);
                });

            sendMetric(['Отправить код ещё раз']);
        },

        operationCancel: function(event) {
            var self = this;

            if (event) {
                this.preventSubmit(event);
            }

            if (!this.operation.id) {
                this.repaintBlocks();
                return;
            }

            this.toggleSpinner();
            passport.api
                .request('yasms.operation.cancel', {
                    id: this.operation.id
                })
                .done(function(response) {
                    if (response.status === 'error') {
                        self.toggleSpinner(true);
                        self.processError(response.errors, event);
                        return;
                    }

                    passport.api.log(['yasms', 'cancel', self.operation.type, self.phoneType].join(' '));
                    self.getState().done(function() {
                        self.repaintBlocks();
                    });
                })
                .fail(function() {
                    self.toggleSpinner(true);
                    self.processError('internal', event);
                });

            sendMetric(['Отменить операцию']);
        },

        operationProlong: function(event, id, $spinner) {
            var self = this;
            var prolongPhoneId = id || this.getSecure().id;

            this.toggleSpinner(null, $spinner);
            passport.api
                .request('yasms.prolong', {
                    id: prolongPhoneId
                })
                .done(function(response) {
                    self.toggleSpinner(true, $spinner);

                    if (response.status === 'error') {
                        if (response.errors.indexOf('action.not_required') === -1) {
                            self.processError(response.errors, event);
                        }

                        return;
                    }

                    self.updateState(event);
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true);
                });
        },

        setDefaultForNotify: function(event, id, $spinner) {
            var self = this;
            var phone = (id && this.yasmsSimple.getPhoneById(id)) || this.getSecure();

            this.operation.type = 'notify';
            this.operation.phone = phone.number;

            this.toggleSpinner(null, $spinner);
            passport.api
                .request('yasms.notify', {
                    id: phone.id
                })
                .done(function(response) {
                    self.toggleSpinner(true, $spinner);

                    if (response.status === 'error') {
                        if (response.errors.indexOf('action.not_required') === -1) {
                            self.processError(response.errors, event);
                        }

                        return;
                    }

                    self.updateState(event);
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true);
                });

            sendMetric(['Установить телефон по-умолчанию для уведомлений']);
        },

        clearOperationParams: function() {
            this.operation = {
                id: null,
                step: null,
                type: null,
                phone: null,
                phoneId: null,
                phoneIdReplaced: null,
                quarantine: null
            };
        },

        operationReplaceParams: function() {
            var replacedPhone = this.yasmsSimple.getPhoneById(this.operation.phoneIdReplaced);

            if (!replacedPhone) {
                return;
            }

            this.operation = $.extend({}, replacedPhone.operation);
            this.operation.type = 'replace';
            this.operation.step = 'confirm-simple';
        },

        enableCaptcha: function() {
            this.captcha.enableCaptcha();
        },

        proceedCaptcha: function() {
            window.YsaLogger.submitEvent({
                name: 'mark',
                payload: {
                    value: 0
                }
            });
            this.captcha.closeCaptcha();
        },

        proceedCaptchaError: function() {
            window.YsaLogger.submitEvent({
                name: 'mark',
                payload: {
                    value: 1
                }
            });
        },

        togglePasswordVisibility: function() {
            var field = this.getControl('password');
            var currentType = field.$control.attr('type');
            var newType = currentType === 'password' ? 'text' : 'password';

            if (!this.canSwitchInputType || !field) {
                return;
            }

            this.togglePasswordVisibilityControls();
            field.$control.attr('type', newType).focus();
        },

        togglePasswordVisibilityControls: function() {
            this.$('.js-password-toggle-visibility').toggleClass('g-hidden');
        },

        checkSwitchFieldType: function() {
            var testInput = document.createElement('input');

            testInput.type = 'text';
            testInput.style.position = 'absolute';
            testInput.style.top = '0';
            testInput.style.left = '-2000px';
            document.body.appendChild(testInput);

            try {
                testInput.type = 'password';
            } catch (e) {
                this.canSwitchInputType = false;
            }

            testInput.style.display = 'none';
        },

        init: function() {
            var errorPopup = $('.js-yasms-error-popup').get(0);
            var $body = $('body');
            var $ysaElem = $('[data-esec-id]');
            var ysaData = $ysaElem.data();
            var match = location.search.match(/mode=(\w*)(&|$)/);
            var mode = (match && match[1]) || 'default';

            this.yasmsSimple = passport.block('yasms-simple');
            this.captcha = passport.block('captcha');
            $ysaElem.remove();
            this.setLocals($body.data('locals') || {});

            $body.removeAttr('data-locals');

            if (ysaData) {
                window.YsaLogger.init({
                    ysaNamespace: ysaData.namespace,
                    ysaEsecId: ysaData.esecId
                });
            }

            if (errorPopup) {
                this.errorPopup = nb.block(errorPopup);
            }
            this.setDefaultState();
            this.bindControls();
            this.checkSwitchFieldType();

            if (mode === 'replace') {
                this.showReplaceState();
            }

            if (!this.canSwitchInputType) {
                this.$('.js-password-toggle-visibility').remove();
            }
        }
    });

    passport.block('yasms-simple', 'yasms', {
        view: 'profile.phones',
        operation: {
            id: null,
            step: null,
            type: null,
            phone: null,
            phoneId: null
        },

        state: 'default',
        switchTemplate: 'simple-phones-form',
        phoneType: 'simple',
        fields: {},

        events: {
            'submit .js-edit-form': 'preventSubmit',
            'click .js-yasms-add': 'operationBind',
            'click .js-yasms-remove': 'operationRemove',
            'click .js-yasms-confirm': 'operationConfirm',
            'click .js-yasms-securify': 'operationSecurify',
            'click .js-yasms-cancel': 'operationCancel',
            'click .js-yasms-cancel-list': 'operationCancelFromList',
            'click .js-yasms-prolong': 'operationProlongFromList',
            'click .js-yasms-notify': 'setDefaultForNotifyFromList',
            'click .js-yasms-proceed-list': 'operationProceed',
            'click .js-yasms-resend-code': 'resendCode',
            'click .js-yasms-show-add-form': 'showBindState'
        },

        getParamFromEvent: function(event, param) {
            if (!event || !param) {
                return false;
            }

            return $(event.target).data(param) || null;
        },

        bindControls: function() {
            var phoneField;
            var codeField;
            var passwordField;

            this.clearControls();

            phoneField = this.$('#yasms-number-simple').get(0);
            codeField = this.$('#yasms-code-simple').get(0);
            passwordField = this.$('#yasms-password-simple').get(0);

            if (phoneField) {
                this.setControl('number', nb.block(phoneField));
            }

            if (codeField) {
                this.setControl('code', nb.block(codeField));
            }

            if (passwordField) {
                this.setControl('password', nb.block(passwordField));
            }

            this.form = this.$('.js-yasms-simple-phone-form');
        },

        showBindState: function() {
            this.switchState('bind');
        },

        setDefaultState: function() {
            var simple = this.getSimple();

            this.clearOperationParams();
            this.state = 'default';

            if (simple && !Array.isArray(simple)) {
                locals.simple = [simple];
            }
        },

        checkSocialchik: function() {
            var locals = this.getLocals();
            var simple = this.getSimple();

            if (simple.length > 0) {
                return;
            }

            if (!locals.isSocialchik || locals.isShowPhonesForNonPasswordExp) {
                return;
            }

            this.switchState('bind');
        },

        repaintPhonesList: function() {
            var secure = this.getSecure();

            if (this.parent.operation.id) {
                secure.operation = $.extend(secure.operation, this.parent.operation);
            }

            this.$('.js-yasms-simple-phone-list').html(yr.run(this.view, this.getLocals(), 'simple-phones-list'));
        },

        repaintBlock: function() {
            this.setDefaultState();
            this.checkSocialchik();
            this.switchState(null, true);
            this.repaintPhonesList();
            this.bindControls();
        },

        operationRemove: function(event) {
            var self = this;
            var id = this.getParamFromEvent(event, 'id');
            var phone = this.getPhoneById(id);
            var $spinner = this.$('.js-yasms-simple-phone-' + id + '-spinner');

            this.operation.type = 'remove';

            if (!id) {
                return;
            }

            if (phone && phone.number) {
                this.operation.phone = phone.number;
            }

            this.toggleSpinner(null, $spinner);
            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type, {
                    id: id
                })
                .done(function(response) {
                    if (response.status === 'error') {
                        self.toggleSpinner(true, $spinner);
                        self.processError(response.errors, event);
                        return;
                    }

                    self.getState().done(function() {
                        self.successOperationNotify();
                        self.repaintBlocks();
                    });
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true, $spinner);
                });

            sendMetric(['Начать удаление телефона']);
        },

        operationSecurify: function(event) {
            var self = this;
            var id = this.getParamFromEvent(event, 'id') || null;
            var $spinner = this.$('.js-yasms-simple-phone-' + id + '-spinner');
            var YsaLogger = window.YsaLogger;

            this.operation.type = 'securify';

            if (!id) {
                return;
            }

            this.toggleSpinner(null, $spinner);
            YsaLogger.flushAllEvents();
            passport.api
                .request('yasms.' + this.phoneType + '.' + this.operation.type + '.submit', {
                    ysaNamespace: YsaLogger.ysaNamespace,
                    ysaEsecId: YsaLogger.ysaEsecId,
                    id: id
                })
                .done(function(response) {
                    var operation = response.operation || null;

                    self.disableControls();
                    self.toggleSpinner(true, $spinner);
                    if (response.status === 'error') {
                        if (response.errors.indexOf('phone_secure.already_exists') !== -1) {
                            self.parent.showReplaceState(event);
                            self.parent.setReplacedPhone(id);
                            return;
                        }

                        self.processError(response.errors, event);
                        return;
                    }

                    if (!operation) {
                        return;
                    }

                    self.operation = $.extend(self.operation, operation);
                    self.switchState('securify');
                })
                .fail(function() {
                    self.processError('internal', event);
                    self.toggleSpinner(true, $spinner);
                })
                .always(function() {
                    self.enableControls();
                });

            sendMetric(['Начать секьюризацию телефона']);
        },

        operationProceed: function(event) {
            var id = this.getParamFromEvent(event, 'id');

            this.operationClone(event);
            this.switchState('confirm', null, true);
            this.$('.js-yasms-control-' + id).remove();
        },

        operationCancelFromList: function(event) {
            this.operationClone(event);
            this.operationCancel(event);
        },

        operationProlongFromList: function(event) {
            var id = this.getParamFromEvent(event, 'id');
            var $spinner = this.$('.js-yasms-simple-phone-' + id + '-spinner');

            this.operationProlong(event, id, $spinner);
        },

        setDefaultForNotifyFromList: function(event) {
            var id = this.getParamFromEvent(event, 'id');
            var $spinner = this.$('.js-yasms-simple-phone-' + id + '-spinner');

            this.setDefaultForNotify(event, id, $spinner);
        },

        operationClone: function(event) {
            var id = this.getParamFromEvent(event, 'id');
            var phone = this.getPhoneById(id);

            if (!phone || !phone.operation) {
                return;
            }

            this.operation = $.extend({}, this.operation, phone.operation);
        },

        markPhone: function(phoneReplaced) {
            var simple = this.getSimple();
            var phone;

            if (!phoneReplaced) {
                return;
            }

            phone = this.getPhoneById(phoneReplaced.id);

            if (phone && phone.id) {
                phone.operation = $.extend({}, phone.operation, {
                    phone: phone.number,
                    id: phoneReplaced.operation.id,
                    phoneId: phoneReplaced.id,
                    type: 'mark'
                });

                return;
            }

            if (!simple.length) {
                locals.simple = [];
            }

            locals.simple.push({
                id: phoneReplaced.id,
                number: phoneReplaced.number || null,
                operation: {
                    phone: phoneReplaced.number || null,
                    id: phoneReplaced.operation.id,
                    phoneId: phoneReplaced.id,
                    type: 'mark'
                }
            });
        },

        getPhoneById: function(id) {
            var simple = this.getSimple();
            var phones;

            if (!id || simple.length === 0) {
                return {};
            }

            phones = simple.filter(function(phone) {
                return phone.id === id;
            });

            return phones[0];
        },

        init: function() {
            var $ysaElem = $('[data-esec-id]');
            var ysaData = $ysaElem.data();

            if (ysaData) {
                window.YsaLogger.init({
                    ysaNamespace: ysaData.namespace,
                    ysaEsecId: ysaData.esecId
                });
            }

            this.bindControls();
            this.setDefaultState();
            this.checkSocialchik();
        }
    });
})();
