#!/bin/bash

# if [ -n "$1" ]
# then
#     BRANCH_TO_BUILD=$1
# else
#     echo 'Build branch should be specified'
#     exit 1
# fi

# if [ -n "$2" ]
# then
#     BUILD_ID=$2
#     MANUAL_BUILD=0
# else
# 	MANUAL_BUILD=1
# fi

# Source checkout directory. Should be synchronized with /debian/rules
# SOURCEDIR=../../
# REPOSITORY=https://github.yandex-team.ru/passport-frontend/passport/

# rm -rf ${SOURCEDIR}
# git clone ${REPOSITORY} ${SOURCEDIR}


# pushd ${SOURCEDIR}
# echo "In ${SOURCEDIR}"

# echo "Checking out ${BRANCH_TO_BUILD} from ${REPOSITORY}"
# git checkout ${BRANCH_TO_BUILD}


# echo "Copying changelog from `pwd`/debian/changelog to ../debian"
VERSION=`dpkg-parsechangelog | sed -n 's/^Version: //p'`
cat ./debian/changelog | sed "s/yandex-passport-frontend/yandex-passport-frontend-static-$VERSION/" > ./build/client/debian/changelog

# echo "Checking release isn't behind master"
# bash ../tools/checkReleaseNotBehindMaster.sh

# popd

echo "Copying dh definitions for version $VERSION"
cp build/client/debian/yandex-passport-frontend-static.dirs.template debian/yandex-passport-frontend-static-${VERSION}.dirs
sed -i "s/{{VERSION}}/$VERSION/g" debian/yandex-passport-frontend-static-${VERSION}.dirs

cp build/client/debian/yandex-passport-frontend-static.install.template debian/yandex-passport-frontend-static-${VERSION}.install
sed -i "s/{{VERSION}}/$VERSION/g" debian/yandex-passport-frontend-static-${VERSION}.install

cp build/client/debian/postinst debian/postinst
sed -i "s/{{VERSION}}/$VERSION/g" debian/postinst
chmod a+x debian/postinst

cp build/client/debian/control debian/control
cp build/client/debian/rules debian/rules
cp build/client/debian/compat debian/compat
cp build/client/debian/changelog debian/changelog
cp build/client/.borschik ./
echo "Writing version into debian/control"
sed -i "s/yandex-passport-frontend-static-/yandex-passport-frontend-static-$VERSION/g" debian/control

cat debian/control

_PWD=`pwd`
_DIR=`basename ${_PWD}`
_PWD=`dirname ${_PWD}`
echo "Building"
# build-package-pbuilder ${_DIR} --upload-to verstka --basetgz base-nodejs.cow --with-cowbuilder --ov-source-path ${_PWD} || exit 3
build-package-pbuilder ${_DIR} --upload-to verstka --basetgz base-nodejs.tgz --ov-source-path ${_PWD} --nosource || exit 3

#echo `conductor-ticket --branch=stable --comment='Uploading static for build http://quigon.yandex.ru/viewLog.html?buildId='${BUILD_ID} --auth ea4dd09cb1046b72fa2b75c42916e91e yandex-passport-frontend-static=${VERSION}`

# echo `conductor-ticket --branch=stable --comment='Uploading static for build https://teamcity.yandex-team.ru/viewLog.html?buildId='${BUILD_ID} --auth glYqW6roKN0Q4Z39X6VSFnW3nket-qjN yandex-passport-frontend-static=${VERSION}`
echo `debticket --branch=stable -n`
