const messengerPresets = require('@yandex-int/messenger.widget').presets;

let tokens;

try {
    /* eslint-disable global-require */
    tokens = require('/usr/lib/yandex/passport-frontend-secrets/tokens.js');
} catch (e) {
    /* eslint-disable no-console */
    console.error('No tokens found');
    tokens = {
        cloudAPIToken: 'FOO',
        connectAPIToken: 'BAR'
    };
}

exports.cloudAPIToken = tokens.cloudAPIToken;
exports.connectAPIToken = tokens.connectAPIToken;

// eslint-disable-next-line max-len
const TLD_REGEXP = /\.(yandex(-team)?\.(?:ru|ua|by|kz|com|com\.tr|az|co\.il|com\.am|com\.ge|ee|fi|fr|kg|lt|lv|md|tj|tm|eu|pl|uz))$|\.(practicum.com|toloka.ai|toloka-test.ai|yango.com)$/;
const beatleUrl = 'https://yastatic.net/s3/frontend/butterfly/latest/butterfly.js';

function createMessengerFrameSrc(dev = false) {
    return function(req) {
        const tld = TLD_REGEXP.exec(req.hostname);
        const host = (dev ? messengerPresets.origin.external.dev : messengerPresets.origin.external.prod).origin;

        if (!tld) {
            return host.replace('{tld}', 'ru');
        }

        return host.replace('yandex.{tld}', tld[1]);
    };
}

exports.CSP = {
    METRIC: function(req) {
        const tld = TLD_REGEXP.exec(req.hostname);

        if (!tld) {
            return null;
        }

        if (tld[1] === 'yandex.ru') {
            return 'mc.admetrica.ru mc.yandex.ru';
        }

        return `mc.admetrica.ru mc.yandex.ru mc.${tld[1]}`;
    },
    PASSPORT_DEV_0: '0.passportdev.yandex.ru',
    API_MAPS: 'api-maps.yandex.ru',
    S3_MDS: 's3.mds.yandex.net',
    S3_MDST: 's3.mdst.yandex.net',
    AVATARS_MDS: 'avatars.mds.yandex.net',
    AVATARS_MDST: 'avatars.mdst.yandex.net',
    BILLING_FRAME: 'https://tmongo1f.fin.yandex.ru',
    BILLING_PREFIX_TEST: 'https://trust-test.',
    BILLING_PREFIX_PROD: 'https://trust.',
    MESSENGER_FRAME: createMessengerFrameSrc(false),
    MESSENGER_FRAME_DEV: createMessengerFrameSrc(true),
    CAPTCHA: '*.captcha.yandex.net',
    CHAT: 'chat.s3.yandex.net',
    MAIL_PREFIX: 'mail.',
    CENTER_YANDEX_TEAM: 'center.yandex-team.ru',
    CLCK: 'clck.yandex.ru',
    DATA: 'data:',
    EXPORT_PREFIX: 'export.',
    FINGERPRINT: 'fingerprint-test.yandex-team.ru',
    IMG_YANDEX_RU: 'img.yandex.ru',
    MAPS: '*.maps.yandex.net',
    MONEY_FRAME: 's4.money.yandex.net',
    BNPL_FRAME_TEST: 'test.bnpl.yandex.ru',
    BNPL_FRAME_PROD: 'split.yandex.ru',
    NONE: "'none'",
    PASSPORT_TEST: 'passport-test.yandex.ru',
    PASS_PREFIX_DEV: 'pass-test.',
    PASS_PREFIX_PROD: 'pass.',
    PASS_PREFIX_RC: 'pass-rc.',
    PASS_PREFIX_TEST: 'pass-test.',
    SELF: "'self'",
    SOCIAL_BROKER: '*.social-dev.yandex.ru',
    STATIC_MAPS: 'static-maps.yandex.ru',
    SUGGEST_MAPS: 'suggest-maps.yandex.net',
    TRUST_TEST: 'trust-test.yandex.ru',
    TRUST: 'trust.yandex.ru trust.yandex.com',
    TLD_REGEXP,
    UNSAFE_EVAL: "'unsafe-eval'",
    UNSAFE_INLINE: "'unsafe-inline'",
    YANDEX_ST: 'yandex.st',
    YANDEX_RU: 'yandex.ru',
    YAPIC: 'yapic.yandex.ru',
    YASTATIC: 'yastatic.net',
    YSA_STATIC_TEST: 'https://ysa-test-static.passport.yandex.ru',
    YSA_STATIC_PROD: 'https://ysa-static.passport.yandex.ru https://ysa-static.passport.yandex.net',
    VIDEO_TUB:
        // eslint-disable-next-line max-len
        'https://video-tub-ru.yandex.net https://img0-tub-ru.yandex.net https://img1-tub-ru.yandex.net https://img2-tub-ru.yandex.net https://img3-tub-ru.yandex.net',
    MAGIC_PREFIX: 'magic.passport',
    BEATLE: beatleUrl,
    FORM_YANDEX: 'https://yandex.ru/forms https://forms.yandex.ru/',
    DOWNLOADER_YANDEX_TEST: 'https://downloader.dst.yandex.ru',
    DOWNLOADER_YANDEX_PROD: 'https://downloader.disk.yandex.ru',
    UPLOAD_DISK_YANDEX_TEST: '*.dst.yandex.net',
    UPLOAD_DISK_YANDEX_PROD: '*.disk.yandex.net',
    API_PASSPORT_TEST: function(req) {
        const tld = TLD_REGEXP.exec(req.hostname);

        if (!tld) {
            return null;
        }

        return `api.passport-test.${tld[1]}`;
    },
    API_PASSPORT: function(req) {
        const tld = TLD_REGEXP.exec(req.hostname);

        if (!tld) {
            return null;
        }

        return `api.passport.${tld[1]}`;
    },
    BLOB: 'blob: ',
    FRAME_ANCESTORS: function(req, res) {
        const tld = TLD_REGEXP.exec(req.hostname);
        const env = process.env.NODE_ENV;

        if (['/auth/smarttv', '/auth/smarttv/', '/auth/smarttv-gateway/', '/auth/smarttv-gateway'].includes(req.path)) {
            if (res.locals.isYandex) {
                return 'file: dev.kinopoisk.ru:* *.smarttv-app.ott.yandex.ru:* https://smarttv-app.ott.yandex.ru';
            }

            if (env === 'production') {
                return 'file: https://smarttv-app.ott.yandex.ru https://*.smarttv-app.ott.yandex.ru';
            }

            return 'file:';
        }

        if (
            tld &&
            [
                '/profile/public',
                '/profile/public/',
                '/profile/email/confirm',
                '/profile/email/confirm/',
                '/auth/update',
                '/auth/update/'
            ].includes(req.path)
        ) {
            return `https://${tld[1]} https://*.${tld[1]}`;
        }

        return "'self'";
    }
};

exports.links = {
    intranet: {
        all: '#',
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex-team.ru',
        calendar: 'https://calendar.yandex-team.ru',
        portal: 'https://portal.yandex-team.ru',
        yamb: 'https://yamb.yandex-team.ru',
        wiki: 'https://wiki.yandex-team.ru',
        meetingrooms: 'https://calendar.yandex-team.ru/invite/',
        st: 'https://st.yandex-team.ru',
        golem: 'https://golem.yandex-team.ru',
        staff: 'https://staff.yandex-team.ru',
        abc: 'https://abc.yandex-team.ru',
        at: 'https://my.at.yandex-team.ru',
        idm: 'https://idm.yandex-team.ru',
        lib: 'https://lib.yandex-team.ru',
        doc: 'https://doc.yandex-team.ru',
        lego: 'https://lego.yandex-team.ru',
        mag: 'https://clubs.at.yandex-team.ru/mag/',
        guide: 'https://guide.yandex-team.ru',
        ml: 'https://ml.yandex-team.ru',
        otrs: 'https://otrs.yandex-team.ru',
        stat: 'https://stat.yandex-team.ru',
        jhist: 'https://jhist.yandex-team.ru',
        contacts: 'https://mail.yandex-team.ru#contacts',
        passport: 'https://passport.yandex-team.ru/profile',
        tracker: 'https://connect.yandex.ru/tracker'
    },
    ru: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.ru',
        maps: 'https://yandex.ru/maps',
        market: 'https://market.yandex.ru',
        images: 'https://yandex.ru/images',
        video: 'http://yandex.ru/video',
        news: 'https://news.yandex.ru',
        pogoda: 'https://pogoda.yandex.ru',
        browser: 'https://browser.yandex.ru',
        music: 'https://music.yandex.ru',
        money: 'https://money.yandex.ru',
        rasp: 'https://rasp.yandex.ru',
        all: 'https://yandex.ru/all',
        yandex: 'https://yandex.ru',
        tune: 'https://tune.yandex.ru',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.ru',
        tv: 'https://tv.yandex.ru',
        afisha: 'https://afisha.yandex.ru',
        search: 'https://yandex.ru',
        portal: 'https://connect.yandex.ru',
        yamb: 'https://yamb.yandex.ru',
        translate: 'https://translate.yandex.ru',
        passport: 'https://passport.yandex.ru/profile',
        tracker: 'https://connect.yandex.ru/tracker'
    },
    by: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.by',
        maps: 'https://yandex.by/maps',
        market: 'https://market.yandex.by',
        images: 'https://yandex.by/images',
        video: 'http://yandex.by/video',
        news: 'https://news.yandex.by',
        pogoda: 'https://pogoda.yandex.by',
        browser: 'https://browser.yandex.by',
        music: 'https://music.yandex.by',
        money: 'https://money.yandex.by',
        rasp: 'https://rasp.yandex.by',
        all: 'https://yandex.by/all',
        yandex: 'https://yandex.by',
        tune: 'https://tune.yandex.by',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.by',
        tv: 'https://tv.yandex.by',
        afisha: 'https://afisha.yandex.by',
        search: 'https://yandex.by',
        portal: 'https://connect.yandex.by',
        yamb: 'https://yamb.yandex.by',
        translate: 'https://translate.yandex.by',
        passport: 'https://passport.yandex.by/profile'
    },
    kz: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.kz',
        maps: 'https://yandex.kz/maps',
        market: 'https://market.yandex.kz',
        images: 'https://yandex.kz/images',
        video: 'http://yandex.kz/video',
        news: 'https://news.yandex.kz',
        pogoda: 'https://pogoda.yandex.kz',
        browser: 'https://browser.yandex.kz',
        music: 'https://music.yandex.kz',
        money: 'https://money.yandex.kz',
        rasp: 'https://rasp.yandex.kz',
        all: 'https://yandex.kz/all',
        yandex: 'https://yandex.kz',
        tune: 'https://tune.yandex.kz',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.kz',
        tv: 'https://tv.yandex.kz',
        afisha: 'https://afisha.yandex.kz',
        search: 'https://yandex.kz',
        portal: 'https://connect.yandex.kz',
        yamb: 'https://yamb.yandex.kz',
        translate: 'https://translate.yandex.kz',
        passport: 'https://passport.yandex.kz/profile'
    },
    com: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.com',
        maps: 'https://yandex.com/maps',
        market: 'https://market.yandex.com',
        images: 'https://yandex.com/images',
        video: 'http://yandex.com/video',
        appmetrica: 'https://appmetrica.yandex.com',
        translate: 'https://translate.yandex.com',
        browser: 'https://browser.yandex.com',
        music: 'https://music.yandex.com',
        all: 'https://yandex.com/all',
        yandex: 'https://yandex.com',
        tune: 'https://tune.yandex.com',
        calendar: 'https://calendar.yandex.com',
        disk: 'https://disk.yandex.com',
        tv: 'https://tv.yandex.com',
        afisha: 'https://afisha.yandex.com',
        search: 'https://yandex.com',
        portal: 'https://connect.yandex.com',
        yamb: 'https://yamb.yandex.com',
        passport: 'https://passport.yandex.com/profile',
        tracker: 'https://connect.yandex.com/tracker'
    },
    'com.tr': {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.com.tr',
        maps: 'https://harita.yandex.com.tr/11508/istanbul',
        images: 'https://yandex.com.tr/gorsel',
        pogoda: 'https://hava.yandex.com.tr',
        all: 'https://yandex.com.tr/all',
        yandex: 'https://yandex.com.tr',
        tune: 'https://tune.yandex.com.tr',
        calendar: 'https://calendar.yandex.com',
        disk: 'https://disk.yandex.com.tr',
        tv: 'https://tv.yandex.com',
        afisha: 'https://afisha.yandex.com',
        search: 'https://yandex.com.tr',
        browser: 'https://browser.yandex.com.tr',
        translate: 'https://translate.yandex.com.tr',
        portal: 'https://connect.yandex.com.tr',
        yamb: 'https://yamb.yandex.com.tr',
        passport: 'https://passport.yandex.com.tr/profile'
    },
    ua: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.ua',
        maps: 'https://yandex.ua/maps/143/kyiv',
        market: 'https://market.yandex.ua',
        images: 'https://yandex.ua/images',
        video: 'http://yandex.ua/video',
        news: 'https://news.yandex.ua',
        pogoda: 'https://pogoda.yandex.ua',
        browser: 'https://browser.yandex.ua',
        music: 'https://music.yandex.ua',
        rasp: 'https://rasp.yandex.ua',
        all: 'https://yandex.ua/all',
        yandex: 'https://yandex.ua',
        tune: 'https://tune.yandex.ua',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.ua',
        tv: 'https://tv.yandex.ua',
        afisha: 'https://afisha.yandex.ua',
        search: 'https://yandex.ua',
        portal: 'https://connect.yandex.ua',
        yamb: 'https://yamb.yandex.ua',
        translate: 'https://translate.yandex.ua',
        passport: 'https://passport.yandex.ua/profile'
    },
    uz: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.uz',
        maps: 'https://yandex.uz/maps/',
        market: 'https://market.yandex.uz',
        images: 'https://yandex.uz/images',
        video: 'http://yandex.uz/video',
        news: 'https://news.yandex.uz',
        pogoda: 'https://yandex.uz/weather',
        browser: 'https://browser.yandex.uz',
        music: 'https://music.yandex.uz',
        rasp: 'https://rasp.yandex.uz',
        all: 'https://yandex.uz/all',
        yandex: 'https://yandex.uz',
        tune: 'https://tune.yandex.uz',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.uz',
        tv: 'https://tv.yandex.uz',
        afisha: 'https://afisha.yandex.uz',
        search: 'https://yandex.uz',
        portal: 'https://connect.yandex.uz',
        yamb: 'https://yamb.yandex.uz',
        translate: 'https://translate.yandex.uz',
        passport: 'https://passport.yandex.uz/profile'
    },
    az: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.az',
        maps: 'https://yandex.az/maps/',
        market: 'https://market.yandex.az',
        images: 'https://yandex.az/images',
        video: 'http://yandex.az/video',
        news: 'https://news.yandex.az',
        pogoda: 'https://yandex.az/weather',
        browser: 'https://browser.yandex.az',
        music: 'https://music.yandex.az',
        rasp: 'https://rasp.yandex.az',
        all: 'https://yandex.az/all',
        yandex: 'https://yandex.az',
        tune: 'https://tune.yandex.az',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.az',
        tv: 'https://tv.yandex.az',
        afisha: 'https://afisha.yandex.az',
        search: 'https://yandex.az',
        portal: 'https://connect.yandex.az',
        yamb: 'https://yamb.yandex.az',
        translate: 'https://translate.yandex.az',
        passport: 'https://passport.yandex.az/profile'
    },
    'com.am': {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.com.am',
        maps: 'https://yandex.com.am/maps/',
        market: 'https://market.yandex.com.am',
        images: 'https://yandex.com.am/images',
        video: 'http://yandex.com.am/video',
        news: 'https://news.yandex.com.am',
        pogoda: 'https://yandex.com.am/weather',
        browser: 'https://browser.yandex.com.am',
        music: 'https://music.yandex.com.am',
        rasp: 'https://rasp.yandex.com.am',
        all: 'https://yandex.com.am/all',
        yandex: 'https://yandex.com.am',
        tune: 'https://tune.yandex.com.am',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.com.am',
        tv: 'https://tv.yandex.com.am',
        afisha: 'https://afisha.yandex.com.am',
        search: 'https://yandex.com.am',
        portal: 'https://connect.yandex.com.am',
        yamb: 'https://yamb.yandex.com.am',
        translate: 'https://translate.yandex.com.am',
        passport: 'https://passport.yandex.com.am/profile'
    },
    'com.ge': {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.com.ge',
        maps: 'https://yandex.com.ge/maps/',
        market: 'https://market.yandex.com.ge',
        images: 'https://yandex.com.ge/images',
        video: 'http://yandex.com.ge/video',
        news: 'https://news.yandex.com.ge',
        pogoda: 'https://yandex.com.ge/weather',
        browser: 'https://browser.yandex.com.ge',
        music: 'https://music.yandex.com.ge',
        rasp: 'https://rasp.yandex.com.ge',
        all: 'https://yandex.com.ge/all',
        yandex: 'https://yandex.com.ge',
        tune: 'https://tune.yandex.com.ge',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.com.ge',
        tv: 'https://tv.yandex.com.ge',
        afisha: 'https://afisha.yandex.com.ge',
        search: 'https://yandex.com.ge',
        portal: 'https://connect.yandex.com.ge',
        yamb: 'https://yamb.yandex.com.ge',
        translate: 'https://translate.yandex.com.ge',
        passport: 'https://passport.yandex.com.ge/profile'
    },
    'co.il': {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.co.il',
        maps: 'https://yandex.co.il/maps/',
        market: 'https://market.yandex.co.il',
        images: 'https://yandex.co.il/images',
        video: 'http://yandex.co.il/video',
        news: 'https://news.yandex.co.il',
        pogoda: 'https://yandex.co.il/weather',
        browser: 'https://browser.yandex.co.il',
        music: 'https://music.yandex.co.il',
        rasp: 'https://rasp.yandex.co.il',
        all: 'https://yandex.co.il/all',
        yandex: 'https://yandex.co.il',
        tune: 'https://tune.yandex.co.il',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.co.il',
        tv: 'https://tv.yandex.co.il',
        afisha: 'https://afisha.yandex.co.il',
        search: 'https://yandex.co.il',
        portal: 'https://connect.yandex.co.il',
        yamb: 'https://yamb.yandex.co.il',
        translate: 'https://translate.yandex.co.il',
        passport: 'https://passport.yandex.co.il/profile'
    },
    kg: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.kg',
        maps: 'https://yandex.kg/maps/',
        market: 'https://market.yandex.kg',
        images: 'https://yandex.kg/images',
        video: 'http://yandex.kg/video',
        news: 'https://news.yandex.kg',
        pogoda: 'https://yandex.kg/weather',
        browser: 'https://browser.yandex.kg',
        music: 'https://music.yandex.kg',
        rasp: 'https://rasp.yandex.kg',
        all: 'https://yandex.kg/all',
        yandex: 'https://yandex.kg',
        tune: 'https://tune.yandex.kg',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.kg',
        tv: 'https://tv.yandex.kg',
        afisha: 'https://afisha.yandex.kg',
        search: 'https://yandex.kg',
        portal: 'https://connect.yandex.kg',
        yamb: 'https://yamb.yandex.kg',
        translate: 'https://translate.yandex.kg',
        passport: 'https://passport.yandex.kg/profile'
    },
    lv: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.lv',
        maps: 'https://yandex.lv/maps/',
        market: 'https://market.yandex.lv',
        images: 'https://yandex.lv/images',
        video: 'http://yandex.lv/video',
        news: 'https://news.yandex.lv',
        pogoda: 'https://yandex.lv/weather',
        browser: 'https://browser.yandex.lv',
        music: 'https://music.yandex.lv',
        rasp: 'https://rasp.yandex.lv',
        all: 'https://yandex.lv/all',
        yandex: 'https://yandex.lv',
        tune: 'https://tune.yandex.lv',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.lv',
        tv: 'https://tv.yandex.lv',
        afisha: 'https://afisha.yandex.lv',
        search: 'https://yandex.lv',
        portal: 'https://connect.yandex.lv',
        yamb: 'https://yamb.yandex.lv',
        translate: 'https://translate.yandex.lv',
        passport: 'https://passport.yandex.lv/profile'
    },
    lt: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.lt',
        maps: 'https://yandex.lt/maps/',
        market: 'https://market.yandex.lt',
        images: 'https://yandex.lt/images',
        video: 'http://yandex.lt/video',
        news: 'https://news.yandex.lt',
        pogoda: 'https://yandex.lt/weather',
        browser: 'https://browser.yandex.lt',
        music: 'https://music.yandex.lt',
        rasp: 'https://rasp.yandex.lt',
        all: 'https://yandex.lt/all',
        yandex: 'https://yandex.lt',
        tune: 'https://tune.yandex.lt',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.lt',
        tv: 'https://tv.yandex.lt',
        afisha: 'https://afisha.yandex.lt',
        search: 'https://yandex.lt',
        portal: 'https://connect.yandex.lt',
        yamb: 'https://yamb.yandex.lt',
        translate: 'https://translate.yandex.lt',
        passport: 'https://passport.yandex.lt/profile'
    },
    md: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.md',
        maps: 'https://yandex.md/maps/',
        market: 'https://market.yandex.md',
        images: 'https://yandex.md/images',
        video: 'http://yandex.md/video',
        news: 'https://news.yandex.md',
        pogoda: 'https://yandex.md/weather',
        browser: 'https://browser.yandex.md',
        music: 'https://music.yandex.md',
        rasp: 'https://rasp.yandex.md',
        all: 'https://yandex.md/all',
        yandex: 'https://yandex.md',
        tune: 'https://tune.yandex.md',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.md',
        tv: 'https://tv.yandex.md',
        afisha: 'https://afisha.yandex.md',
        search: 'https://yandex.md',
        portal: 'https://connect.yandex.md',
        yamb: 'https://yamb.yandex.md',
        translate: 'https://translate.yandex.md',
        passport: 'https://passport.yandex.md/profile'
    },
    tj: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.tj',
        maps: 'https://yandex.tj/maps/',
        market: 'https://market.yandex.tj',
        images: 'https://yandex.tj/images',
        video: 'http://yandex.tj/video',
        news: 'https://news.yandex.tj',
        pogoda: 'https://yandex.tj/weather',
        browser: 'https://browser.yandex.tj',
        music: 'https://music.yandex.tj',
        rasp: 'https://rasp.yandex.tj',
        all: 'https://yandex.tj/all',
        yandex: 'https://yandex.tj',
        tune: 'https://tune.yandex.tj',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.tj',
        tv: 'https://tv.yandex.tj',
        afisha: 'https://afisha.yandex.tj',
        search: 'https://yandex.tj',
        portal: 'https://connect.yandex.tj',
        yamb: 'https://yamb.yandex.tj',
        translate: 'https://translate.yandex.tj',
        passport: 'https://passport.yandex.tj/profile'
    },
    tm: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.tm',
        maps: 'https://yandex.tm/maps/',
        market: 'https://market.yandex.tm',
        images: 'https://yandex.tm/images',
        video: 'http://yandex.tm/video',
        news: 'https://news.yandex.tm',
        pogoda: 'https://yandex.tm/weather',
        browser: 'https://browser.yandex.tm',
        music: 'https://music.yandex.tm',
        rasp: 'https://rasp.yandex.tm',
        all: 'https://yandex.tm/all',
        yandex: 'https://yandex.tm',
        tune: 'https://tune.yandex.tm',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.tm',
        tv: 'https://tv.yandex.tm',
        afisha: 'https://afisha.yandex.tm',
        search: 'https://yandex.tm',
        portal: 'https://connect.yandex.tm',
        yamb: 'https://yamb.yandex.tm',
        translate: 'https://translate.yandex.tm',
        passport: 'https://passport.yandex.tm/profile'
    },
    fr: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.fr',
        maps: 'https://yandex.fr/maps/',
        market: 'https://market.yandex.fr',
        images: 'https://yandex.fr/images',
        video: 'http://yandex.fr/video',
        news: 'https://news.yandex.fr',
        pogoda: 'https://yandex.fr/weather',
        browser: 'https://browser.yandex.fr',
        music: 'https://music.yandex.fr',
        rasp: 'https://rasp.yandex.fr',
        all: 'https://yandex.fr/all',
        yandex: 'https://yandex.fr',
        tune: 'https://tune.yandex.fr',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.fr',
        tv: 'https://tv.yandex.fr',
        afisha: 'https://afisha.yandex.fr',
        search: 'https://yandex.fr',
        portal: 'https://connect.yandex.fr',
        yamb: 'https://yamb.yandex.fr',
        translate: 'https://translate.yandex.fr',
        passport: 'https://passport.yandex.fr/profile'
    },
    ee: {
        kinopoisk: 'https://www.kinopoisk.ru',
        mail: 'https://mail.yandex.ee',
        maps: 'https://yandex.ee/maps/',
        market: 'https://market.yandex.ee',
        images: 'https://yandex.ee/images',
        video: 'http://yandex.ee/video',
        news: 'https://news.yandex.ee',
        pogoda: 'https://yandex.ee/weather',
        browser: 'https://browser.yandex.ee',
        music: 'https://music.yandex.ee',
        rasp: 'https://rasp.yandex.ee',
        all: 'https://yandex.ee/all',
        yandex: 'https://yandex.ee',
        tune: 'https://tune.yandex.ee',
        calendar: 'https://calendar.yandex.ru',
        disk: 'https://disk.yandex.ee',
        tv: 'https://tv.yandex.ee',
        afisha: 'https://afisha.yandex.ee',
        search: 'https://yandex.ee',
        portal: 'https://connect.yandex.ee',
        yamb: 'https://yamb.yandex.ee',
        translate: 'https://translate.yandex.ee',
        passport: 'https://passport.yandex.ee/profile'
    }
};

exports.yamoneySecret = 'yamoney-123456';

exports.experiments = {
    registration: {
        robots: ['0', '1', '2', '3', '4', '5', '6', '7']
    }
};

exports.ipreg = {
    lib: '/usr/lib/node_modules/ipreg',
    lookup: '/var/cache/geobase/layout.json'
};

exports.retries = {
    timeout: 3,
    error: 3
};

exports.securityLevels = {
    '-1': 'undefined',
    4: 'low',
    16: 'middle',
    32: 'high'
};

exports.forcedMDADomains = ['edadeal.ru', 'edastage.ru'];

// https://wiki.yandex-team.ru/JandeksPoisk/TematicheskiePoiski/GeoPoisk/metrics/mapreqanslog/origin/
exports.geoCoderOrigin = 'maps-passport-dev';
exports.tunePlaces = 'https://yandex.%tld%/tune/places';
exports.marketAddresses = 'https://market.yandex.%tld%/my/settings#address';
exports.socialStatic = '//yastatic.net/broker/2.0.12-0';
exports.staticMaps = 'https://static-maps.yandex.ru';
exports.beatleUrl = beatleUrl;
exports.ticketsFile = '/var/cache/yandex/passport-tvm-keyring/passport_frontend.tickets';
exports.yaPayLanding = 'https://pay.yandex.ru/';

exports.neoPhonishPrefix = 'nphne-';

exports.subscriptions = {
    chatGuid: '80027008-e39a-986b-5f64-822d65ab117c'
};

exports.ysaIdMap = {
    auth: '96eb29b255b84bfd7016c2420aa13870',
    registration: '4db0a3e1b91dc2d525d7297800182592'
};

exports.legalLinks = {
    confidential: 'https://yandex.%tld%/legal/confidential/',
    rules: 'https://yandex.%tld%/legal/rules/'
};

exports.signup = {
    registerWithFullPersonalInfoOrigins: [
        'full_personal_info', // debug
        'full_personal_info_neo', // debug
        'flowservice_sales_funnel',
        'market_touch_full_personal_info_checkout',
        'market_desktop_full_personal_info_checkout'
    ]
};

exports.deleteDataTestingBaseUrls = {
    adfox: 'https://takeout-test.ui-dev.adfox.yandex.ru/api/internal/takeout/1',
    afishadata: 'https://api.tickets.afisha.tst.yandex.net/1',
    alisa: 'https://gdprvoiceproxy.tst.common.yandex.net/1',
    appmetrika: 'https://mobmet-intapi-test.metrika.yandex.net/1',
    audience: 'https://audience-intapid.test.metrika.yandex.net/1/takeout/status',
    browser: 'https://private.sync-test.browser.yandex.net/1',
    blogs: 'http://blogs-api-testing.yandex.net/v1',
    carsharing: 'https://testing.carsharing.yandex.net/api',
    collections: 'https://l7test.yandex.ru/collections/api/1',
    commentator: 'https://mssngr-gdpr-alpha.search.yandex.net/1',
    contest: 'https://internal-test.contest.yandex.net/1',
    crypta: 'http://styx-test.crypta.yandex.net/1',
    deli: 'http://takeout.taxi.tst.yandex.net/1',
    edadeal: 'https://vanisher.edastage.yandex.net/1',
    eats: 'http://takeout.taxi.tst.yandex.net/1',
    games: 'https://admin-api.games-test.yandex.ru/1',
    forms: 'https://forms-ext-api.test.yandex.ru/1',
    geosmb: 'https://cleaner.tst.geosmb.maps.yandex.net/1',
    kinopoisk: 'https://gdpr-api.tst.kp.yandex.net/1',
    lavka: 'http://takeout.taxi.tst.yandex.net/1',
    mapsbooking: 'https://booking-int.gdpr.tst.maps.yandex.net/v1',
    mapsconstructor: 'https://constructor-int.gdpr.tst.slb.maps.yandex.net/v2',
    maps: 'http://core-feedback-userapi.testing.maps.yandex.net/v1',
    mapshistory: 'https://bookmarks-int.gdpr.tst.maps.yandex.net/datasync/v1',
    mapsmrc: 'http://core-nmaps-mrc-tasksplanner.testing.maps.yandex.net/1',
    mapspano: 'http://core-stv-ugc.testing.maps.yandex.net/1',
    mapsphoto: 'http://core-pht-ugc.testing.maps.n.yandex.ru/1',
    mapsroadevents: 'http://infopoints.tst.maps.yandex.ru/1',
    mapsugc: 'http://core-ugc-account.testing.maps.yandex.net/v1',
    market: 'https://market-takeout.tst.vs.market.yandex.net/1',
    messenger: 'https://mssngr-gdpr-alpha.search.yandex.net/1',
    metrika: 'https://internalapi.test.metrika.yandex.net/1',
    music: 'http://music-web-ext.music.qa.yandex.net/internal-api/1',
    navigator: 'https://bookmarks-int.gdpr.tst.maps.yandex.net/datasync/v1',
    nmaps: 'http://core-nmaps-gdpr.common.testing.maps.yandex.net/2',
    overload: 'https://overload.yandex.net',
    plusstatistic: 'https://api.plus.tst.yandex.ru/1',
    portal: 'https://portal-takeout-v197d2.wdevx.yandex.ru/1',
    praktikum: 'https://testing.pierce.praktikum.yandex.ru/1',
    profi: 'https://takeout-test.profi.yandex.net/1',
    q: 'https://answers-admin-testing.n.yandex-team.ru/znatoki/admin/api/1',
    realty: 'https://realty-takeout.test.vertis.yandex.net/api/1.x',
    schoolbook: 'https://testing.api.schoolbook.yandex.ru/1',
    sitesearch: 'https://sitesearch-viewer.test.n.yandex-team.ru',
    surveys: 'https://pythia-staging.common.yandex.ru/api/v0',
    tanker: 'https://app.tst.tanker.yandex.net/api/1',
    taxi: 'http://takeout.taxi.tst.yandex.net/1',
    telemed: 'https://staging.telemed.in.yandex-team.ru',
    toloka: 'https://tlkback-1478.admin.toloka.tst.yandex.com/1',
    translate: 'http://translate-misc.yandex.net/1',
    travelorchestrator: 'https://api.travel-balancer-test.yandex.net/1',
    ugc: 'http://ugc-test.search.yandex.net/api',
    uslugi: 'https://internal-dev.ydo.yandex.net/ydo/api/takeout/1',
    weather: 'https://l7test.yandex.ru/pogoda/front/1',
    webmaster: 'https://webmaster3-internal.test.in.yandex.net/1',
    xmlsearch: 'https://xml-user.test.in.yandex.net/1',
    zen: 'http://apis-test.kaizen.yandex.net/api-v1/1'
};

exports.deleteDataBaseUrls = {
    adfox: 'https://api-internal.adfox.net/api/internal/takeout/1',
    afishadata: 'https://api.tickets.afisha.yandex.net/1',
    alisa: 'https://gdprvoiceproxy.yandex.net/1',
    appmetrika: 'https://mobmet-intapi.metrika.yandex.net/1',
    audience: 'https://audience-intapi.metrika.yandex.net/1',
    browser: 'https://private.sync.browser.yandex.net/1',
    blogs: 'http://blogs-api-production.yandex.net/v1',
    carsharing: 'https://stable.carsharing.yandex.net/api',
    collections: 'https://yandex.ru/collections/api/1',
    commentator: 'https://mssngr-gdpr.search.yandex.net/1',
    contest: 'https://internal.contest.yandex.net/1',
    crypta: 'http://styx.crypta.yandex.net/1',
    deli: 'http://takeout.taxi.yandex.net/1',
    edadeal: 'https://vanisher.edadeal.yandex.net/1',
    eats: 'http://takeout.taxi.yandex.net/1',
    games: 'https://admin-api.games.yandex.ru/1',
    forms: 'https://forms-ext-api.yandex.ru/1',
    geosmb: 'https://cleaner.geosmb.maps.yandex.net/1',
    kinopoisk: 'https://gdpr-api.kp.yandex.net/1',
    lavka: 'http://takeout.taxi.yandex.net/1',
    mapsbooking: 'https://booking-int.gdpr.maps.yandex.net/v1',
    mapsconstructor: 'https://constructor-int.gdpr.maps.yandex.net/v2',
    maps: 'http://core-feedback-userapi.maps.yandex.net/v1',
    mapshistory: 'https://bookmarks-int.gdpr.maps.yandex.net/datasync/v1',
    mapsmrc: 'http://core-nmaps-mrc-tasksplanner.maps.yandex.net/1',
    mapspano: 'http://core-stv-ugc.maps.yandex.net/1',
    mapsphoto: 'http://core-pht-ugc.maps.yandex.net/1',
    mapsroadevents: 'http://infopoints.maps.yandex.net/1',
    mapsugc: 'http://core-ugc-account.maps.yandex.net/v1',
    market: 'https://market-takeout.vs.market.yandex.net/1',
    messenger: 'https://mssngr-gdpr.search.yandex.net/1',
    metrika: 'https://internalapi.metrika.yandex.net/1',
    music: 'http://music-web-ext.music.yandex.net/internal-api/1',
    navigator: 'https://bookmarks-int.gdpr.maps.yandex.net/datasync/v1',
    nmaps: 'http://core-nmaps-gdpr.maps.yandex.net/2',
    overload: 'https://overload.yandex.net',
    plusstatistic: 'https://api.plus.yandex.ru/1',
    portal: 'https://portal-takeout.yandex.net/1',
    praktikum: 'https://pierce.praktikum.yandex.ru/1',
    profi: 'https://takeout.profi.yandex.net/1',
    q: 'https://answers-admin.n.yandex-team.ru/znatoki/admin/api/1',
    realty: 'https://realty-takeout.vertis.yandex.net/api/1.x',
    schoolbook: 'https://takeout.schoolbook.yandex.ru/1',
    sitesearch: 'https://sitesearch-takeout.yandex.net/1',
    surveys: 'https://surveys.yandex.ru/api/v0',
    tanker: 'https://app.tanker.yandex.net/api/1',
    taxi: 'http://takeout.taxi.yandex.net/1',
    telemed: 'https://prod.med.yandex-team.ru/takeout',
    toloka: 'https://takeout.toloka.yandex.net/1',
    translate: 'http://translate-misc.yandex.net/1',
    travelorchestrator: 'https://api-prod.travel-hotels.yandex.net/1',
    ugc: 'https://ugc.search.yandex.net/api',
    uslugi: 'https://ydo-internal.yandex.net/ydo/api/takeout/1',
    weather: 'https://yandex.ru/pogoda/front/1',
    webmaster: 'https://webmaster3-internal.prod.in.yandex.net/1',
    xmlsearch: 'https://xml-user.prod.in.yandex.net/1',
    zen: 'http://apis.kaizen.yandex.net/api-v1/1'
};

exports.sessguardDomains = [
    'a.',
    'abc.',
    'bot.',
    'crt-api.',
    'crt.',
    'deploy.',
    'eds.',
    'help.',
    'idm.',
    'juggler.',
    'kolhoz.',
    'mail.',
    'nanny.',
    'newci.',
    'nirvana.',
    'oauth.',
    'oauth-test.',
    'ok.',
    'puncher.',
    'q.',
    'review.',
    'sandbox.',
    'st.',
    'staff.',
    'sts.',
    'wiki.',
    'yasms-test.',
    'yasms.',
    'yav.',
    'yql.',
    'yt.'
];

// seconds
exports.otpSessionReissueInterval = 180;
