const common = require('../common');
const url = require('url');
const _ = require('lodash');
const CSP = common.CSP;

exports.version = '{{VERSION}}';
exports.defaults = {
    url: {
        protocol: 'http',
        hostname: '127.0.0.1',
        port: '80',
        pathname: '/1/'
    },
    headers: {
        Host: 'passport-internal.yandex.ru',
        'User-Agent': 'got',
        'content-type': 'application/x-www-form-urlencoded'
    },
    qs: {
        consumer: 'passport'
    },
    method: 'POST',
    timeout: 10000
};

exports.enablePlusDomain = true;
exports.dev = false;

exports.api = {
    yasms: {
        dao: {
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            retryCodes: ['INTERROR'],
            timeout: 8000
        }
    },
    oauth: {
        dao: {
            baseUrl: 'http://oauth-internal.yandex.ru/iface_api',
            maxRetries: 3,
            maxConnections: 100,
            retryAfter: 500, // Milliseconds to wait before retrying
            retryCodes: ['backend.failed'],
            timeout: 1000
        }
    },
    passport: {
        dao: {
            baseUrl: url.format(_.assign({}, exports.defaults.url, {pathname: null})),
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 300, // Milliseconds to wait before retrying
            retryCodes: ['blackboxfailed'],
            timeout: exports.defaults.timeout
        }
    },
    disk: {
        dao: {
            baseUrl: 'http://sync.disk.yandex.net:8090',
            maxRetries: 3,
            maxConnections: 100,
            retryAfter: 500, // Milliseconds to wait before retrying
            timeout: 1000
        }
    },
    cloud: {
        dao: {
            baseUrl: 'https://intapi.disk.yandex.net:8443',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    connect: {
        dao: {
            baseUrl: 'https://api.directory.yandex.ru',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    geo: {
        dao: {
            baseUrl: 'http://addrs.yandex.ru:17140',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    billing: {
        dao: {
            baseUrl: 'http://music-web-ext.music.yandex.net/internal-api',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    afisha: {
        dao: {
            baseUrl: 'https://api.draqla.afisha.yandex.net',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 1000
        }
    },
    iot: {
        dao: {
            baseUrl: 'http://iot.quasar.yandex.net:80',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    kinopoisk: {
        dao: {
            baseUrl: 'https://api.ott.yandex.ru:443',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    avatars: {
        dao: {
            baseUrl: 'http://avatars-int.mds.yandex.net:13000',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    billingInternal: {
        dao: {
            baseUrl: 'http://api.mediabilling.yandex.net:80/',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    plusLanding: {
        dao: {
            baseUrl: 'https://landing.plus.yandex.net:443/',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    trustPayments: {
        dao: {
            token: 'passport_d056025fbea3c4700729c5b96b0ff97b',
            baseUrl: 'https://trust-payments.paysys.yandex.net/trust-payments',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 8000
        }
    },
    trustApi: {
        dao: {
            baseUrl: 'https://api.trust.yandex.net',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 200
        }
    },
    praktikum: {
        dao: {
            baseUrl: 'https://pierce.praktikum.yandex.ru',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    deleteData: {
        baseUrls: common.deleteDataBaseUrls,
        dao: {
            maxRetries: 3,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 1000
        }
    },
    familypay: {
        dao: {
            baseUrl: 'https://familypay-backend.so.yandex.net',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 1000
        }
    },
    antifraud: {
        dao: {
            baseUrl: 'https://fraud.so.yandex-team.ru',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 2000
        }
    },
    bnpl: {
        dao: {
            baseUrl: 'http://bnpl.fintech.yandex.net',
            maxRetries: 2,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 500
        }
    },
    documents: {
        dao: {
            baseUrl: 'https://documents-prod.pers.yandex.net',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 8000
        }
    }
};

exports.fullname = {
    url: 'http://mail-extract.mail.yandex.net/?e=name',
    method: 'POST',
    jar: false,
    pool: {
        maxSockets: 100
    },
    timeout: 200
};

exports.langs = ['ru', 'uk', 'en', 'tr', 'id', 'fr', 'fi', 'kk', 'uz', 'az', 'he', 'ky', 'pt'];

exports.paths = {
    retpath: '/passport?mode=passport',
    basic: '/registration',
    static: '{{STATIC_PATH}}',
    blackbox: 'blackbox.yandex.net',
    mda: 'sso.passport.yandex.ru',
    social_static: common.socialStatic,
    providers: 'http://social.yandex.ru/providers-domik.json',
    broker: 'https://social.yandex.%tld%/broker2/start',
    oauth: 'oauth.yandex.%tld%',
    plus: 'plus.yandex.%tld%',
    passport: 'passport.yandex.%tld%',
    internal: 'passport-internal.yandex.ru',
    internalPort: '81',
    experiments: 'http://uaas.search.yandex.net/passport',
    mds: 'https://avatars.mds.yandex.net',
    collectionsCard: 'https://yandex.ru/collections/card',
    collectionsUser: 'https://yandex.ru/collections/user',
    video: 'https://yandex.ru/video/favorites?filmId=%id%',
    avatar: {
        host: 'avatars.mds.yandex.net',
        pathname: '/get-yapic/%uid%/islands-%size%',
        default_300: 'https://avatars.mds.yandex.net/get-yapic/0/0-0/islands-300',
        avatar_300: 'https://avatars.mds.yandex.net/get-yapic/%avatar_id%/islands-300'
    },
    ysa: {
        static: 'https://ysa-static.passport.yandex.net',
        hostname: 'ysa.passport.yandex.net',
        port: '80'
    },
    yasms: 'http://sms.passport.yandex.ru',
    unread: {
        host: 'export.yandex.%tld%',
        pathname: '/for/unread.xml'
    },
    loginStatusPath: '/auth/login-status.html',
    bigbro: {
        hostname: 'karma.yandex.net',
        port: '80'
    },
    help: {
        passport: 'https://yandex.%tld%/support/passport/',
        restore: 'https://yandex.%tld%/support/passport/',
        change_password: 'https://yandex.%tld%/support/passport/security/force-password-change.xml',
        change_password_form: 'https://yandex.%tld%/support/passport/security/force-password-change-form.xml',
        auth_challenges: 'https://yandex.%tld%/support/passport/security/login-challenge-form.xml',
        phones: 'https://www.yandex.%tld%/support/passport/authorization/phone.html',
        'restore-semiauto': 'https://yandex.%tld%/support/passport/support-restore.xml',
        kiddish: 'https://yandex.%tld%/support/kinopoisk/online/kids-mode.html'
    },
    logs: {
        graphite: '/var/log/yandex/passport-frontend/graphite.log',
        requests: '/var/log/yandex/passport-frontend/requests.log',
        accountVerification: '/var/log/yandex/passport-account-verification/data.log',
        accountVerificationPPL: '/var/log/yandex/passport-account-verification/data-ppl.log'
    },
    emailValidator: '//passport.yandex.%tld%/profile/emails/',
    embeddedauth: '//passport.yandex.%tld%/passport?mode=embeddedauth',
    yamoney: {
        hostname: 'shiro-export.yamoney.ru',
        port: 8082
    },
    amExperiments: {
        hostname: 'uaas.passport.yandex.net',
        port: 80,
        pathname: '/1/bundle/experiments/by_device_id/'
    },
    mapsAPI: 'https://api-maps.yandex.ru/2.1/?lang=%lang%',
    yamoneyCards: 'https://money.yandex.%tld%/cards',
    tunePlaces: common.tunePlaces,
    marketAddresses: common.marketAddresses,
    staticMaps: common.staticMaps,
    authCustomsStatic: 'https://yastatic.net/s3/passport-auth-customs/',
    magicQrUrl: 'https://magic.passport.yandex.ru',
    accountsUrl: '//api.passport.yandex.%tld%/all_accounts',
    yaPayLanding: common.yaPayLanding
};

exports.intranetPaths = {
    retpath: '/passport?mode=passport',
    blackbox: 'blackbox.yandex-team.ru',
    mda: 'pass.yandex-team.ru'
};

exports.brokerParams = {
    startUrl: '/auth/social/start',
    retpath: '/auth/i-social__closer.html',
    consumer: 'passport',
    popupName: 'passport_social',
    display: 'popup',
    place: 'fragment'
};

/**
 * Billing connection
 * @see https://wiki.yandex-team.ru/Balance/Simple
 */
exports.billing = {
    url: 'http://balance-xmlrpc.yandex.net:8002/simpleapi/xmlrpc',
    token: 'mobile_yastore_22f7f32c7bd262ba38b31e755127399c'
};

/**
 * @see /routes/metrics.js
 */
exports.metrics = {
    '/': '784657',
    '/registration/connect': '42999529',
    '/registration/mail': '10053691',
    '/profile/data': '84093838'
};

exports.restore = {
    feedback: 'https://feedback2.yandex.ru/passport/spprstr/',
    blocked: 'https://feedback2.yandex.ru/passport/blocked/'
};

exports.audioCaptcha = {
    whitelist: ['KZ', 'UA', 'BY', 'RU', 'TR']
};

/**
 * Log level for the logs
 * @type {string}
 */
exports.loglevel = 'INFO';
exports.multiauth = true;
exports.multiauthPinning = true;

exports.appPasswordsClientIdMapping = {
    d70555c89e7840ce8de434962014369d: 'mail',
    '8a14a05d50174be6a4475611dd1a7259': 'disk',
    d426ba94bed64c759d04ffb942942994: 'addrbook',
    '773adca0973d47e1a43c36b01ab997d4': 'calendar',
    fa811d06cb7c44f6b18f13c3e99cec1a: 'chat',
    ce6ed0f691294fd6b5972bc0959335bc: 'magnitola',
    '122a5db724824fa0ad3788de112acb9b': 'collector'
};

exports.corsAllowed = ['https://passport.yandex', 'https://oauth.yandex'].reduce((acc, service) => {
    [
        'az',
        'com.am',
        'com.ge',
        'co.il',
        'kg',
        'lv',
        'lt',
        'md',
        'tj',
        'tm',
        'uz',
        'fr',
        'ee',
        'eu',
        'ru',
        'ua',
        'by',
        'kz',
        'com',
        'com.tr'
    ].forEach((tld) => {
        acc.push(`${service}.${tld}`);
    });

    return acc;
}, []);

exports.journalEventsLimits = {
    logLimit: 5,
    mapLimit: 999
};

exports.workspace = {
    zone: 'yaconnect.com'
};

exports.helmet = {
    csp: {
        directives: {
            defaultSrc: [CSP.NONE],
            styleSrc: [CSP.SELF, CSP.YASTATIC, CSP.UNSAFE_INLINE, CSP.UNSAFE_EVAL, CSP.S3_MDS, CSP.S3_MDST],
            scriptSrc: [
                CSP.SELF,
                CSP.YASTATIC,
                CSP.METRIC,
                CSP.CHAT,
                CSP.API_MAPS,
                CSP.SUGGEST_MAPS,
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.EXPORT_PREFIX + tld[1];
                },
                CSP.UNSAFE_EVAL,
                CSP.UNSAFE_INLINE,
                function(req, res) {
                    return `'nonce-${res.locals.nonce}'`; // CSPv2 nonce directive for inline scripts
                },
                CSP.BEATLE
            ],
            imgSrc: [
                CSP.SELF,
                CSP.YASTATIC,
                CSP.YSA_STATIC_PROD,
                CSP.YANDEX_ST,
                CSP.DATA,
                CSP.METRIC,
                CSP.API_MAPS,
                CSP.CAPTCHA,
                CSP.S3_MDS,
                CSP.S3_MDST,
                CSP.AVATARS_MDS,
                CSP.AVATARS_MDST,
                CSP.CLCK,
                CSP.MAPS,
                CSP.YAPIC,
                CSP.IMG_YANDEX_RU,
                CSP.STATIC_MAPS,
                CSP.VIDEO_TUB,
                CSP.BLOB,
                'mc.webvisor.com',
                'mc.webvisor.org',
                CSP.DOWNLOADER_YANDEX_PROD
            ],
            fontSrc: [CSP.SELF, CSP.DATA, CSP.YASTATIC],
            objectSrc: [CSP.YASTATIC],
            mediaSrc: [CSP.CAPTCHA, CSP.DATA],
            connectSrc: [
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.MAIL_PREFIX + tld[1];
                },
                CSP.SELF,
                CSP.METRIC,
                CSP.TRUST,
                CSP.SUGGEST_MAPS,
                'mc.webvisor.com',
                'mc.webvisor.org',
                CSP.YANDEX_RU,
                CSP.API_PASSPORT,
                CSP.UPLOAD_DISK_YANDEX_PROD
            ],
            frameAncestors: [CSP.FRAME_ANCESTORS],
            frameSrc: [
                CSP.SELF,
                CSP.YANDEX_ST,
                CSP.MONEY_FRAME,
                CSP.MESSENGER_FRAME,
                CSP.BNPL_FRAME_PROD,
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return tld[1];
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (
                        tld &&
                        ['yandex.ua', 'yandex.by', 'yandex.kz'].indexOf(tld[1]) > -1 &&
                        req.cookies.mda !== '0'
                    ) {
                        return [
                            `${req.hostname.replace(tld[1], 'yandex.ru')}`,
                            `${CSP.PASS_PREFIX_PROD}yandex.ru`,
                            'passport.yandex.ru'
                        ].join(' ');
                    }

                    return null;
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.PASS_PREFIX_PROD + tld[1];
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return `passport.${tld[1]}`;
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.BILLING_PREFIX_PROD + tld[1];
                },
                'blob:',
                'mc.yandex.ru',
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return `${CSP.MAGIC_PREFIX}.${tld[1]}`;
                },
                CSP.FORM_YANDEX
            ],
            childSrc: [
                CSP.SELF,
                CSP.YANDEX_ST,
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return tld[1];
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (
                        tld &&
                        ['yandex.ua', 'yandex.by', 'yandex.kz'].indexOf(tld[1]) > -1 &&
                        req.cookies.mda !== '0'
                    ) {
                        return [
                            `${req.hostname.replace(tld[1], 'yandex.ru')}`,
                            `${CSP.PASS_PREFIX_PROD}yandex.ru`,
                            'passport.yandex.ru'
                        ].join(' ');
                    }

                    return null;
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return `passport.${tld[1]}`;
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.PASS_PREFIX_PROD + tld[1];
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.BILLING_PREFIX_PROD + tld[1];
                },
                'blob:',
                'mc.yandex.ru'
            ],
            reportUri: [
                (req) => {
                    return url.format({
                        protocol: 'https',
                        hostname: 'csp.yandex.net',
                        pathname: 'csp',
                        query: {
                            from: 'passport',
                            project: 'passport',
                            yandex_login: req.cookies.yandex_login,
                            yandexuid: req.cookies.yandexuid
                        }
                    });
                }
            ],
            manifestSrc: [CSP.SELF]
        },
        reportOnly: false
    },
    frameguard: 'DENY',
    noCache: {
        noEtag: true
    }
};

exports.plusAvailableTld = ['ru', 'kz', 'by'];

exports.plusAvailableCountries = {
    225: 'ru',
    159: 'kz',
    149: 'by'
};

exports.experiments = common.experiments;

exports.links = common.links;

exports.secrets = {
    yamoney: common.yamoneySecret
};

exports.retries = common.retries;

exports.securityLevels = common.securityLevels;
exports.cloudAPIToken = common.cloudAPIToken;
exports.connectAPIToken = common.connectAPIToken;
exports.billingFrame = CSP.BILLING_PREFIX_PROD;
exports.cspTldRegexp = CSP.TLD_REGEXP;
// https://wiki.yandex-team.ru/JandeksPoisk/TematicheskiePoiski/GeoPoisk/metrics/mapreqanslog/origin/
exports.geoCoderOrigin = 'maps-passport';
exports.ticketsFile = common.ticketsFile;
exports.neoPhonishPrefix = common.neoPhonishPrefix;
exports.subscriptions = common.subscriptions;
exports.ysaIdMap = common.ysaIdMap;
exports.signup = common.signup;
exports.otpSessionReissueInterval = common.otpSessionReissueInterval;
