const common = require('../common');
const url = require('url');
const _ = require('lodash');
const CSP = common.CSP;

exports.version = '{{VERSION}}';
exports.defaults = {
    url: {
        protocol: 'http',
        hostname: '127.0.0.1',
        port: '6000',
        pathname: '/1/'
    },
    headers: {
        'content-type': 'application/x-www-form-urlencoded',
        'User-Agent': 'got'
    },
    qs: {
        consumer: 'passport'
    },
    method: 'POST',
    timeout: 10000
};

exports.api = {
    yasms: {
        dao: {
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            retryCodes: ['INTERROR'],
            timeout: 8000
        }
    },
    oauth: {
        dao: {
            baseUrl: 'http://oauth-internal.yandex-team.ru/iface_api',
            maxRetries: 3,
            maxConnections: 100,
            retryAfter: 500, // Milliseconds to wait before retrying
            retryCodes: ['backend.failed'],
            timeout: 1000
        }
    },
    passport: {
        dao: {
            baseUrl: url.format(_.assign({}, exports.defaults.url, {pathname: null})),
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 300, // Milliseconds to wait before retrying
            retryCodes: ['blackboxfailed'],
            timeout: exports.defaults.timeout
        }
    },
    disk: {
        dao: {
            baseUrl: 'http://sync.disk.yandex.net:8090',
            maxRetries: 3,
            maxConnections: 100,
            retryAfter: 500, // Milliseconds to wait before retrying
            timeout: 1000
        }
    },
    cloud: {
        dao: {
            baseUrl: 'http://intapi.disk.yandex.net:8080',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    connect: {
        dao: {
            baseUrl: 'https://api.test.directory.yandex.ru',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    geo: {
        dao: {
            baseUrl: 'http://addrs-testing.search.yandex.net/search/stable',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    afisha: {
        dao: {
            baseUrl: 'https://api.draqla.afisha.yandex.net',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 1000
        }
    },
    iot: {
        dao: {
            baseUrl: 'http://iot.quasar.yandex.net:80',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    kinopoisk: {
        dao: {
            baseUrl: 'https://api.ott.yandex.ru:443',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    billingInternal: {
        dao: {
            baseUrl: 'http://api.mediabilling.yandex.net:80/',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    plusLanding: {
        dao: {
            baseUrl: 'https://landing.plus.yandex.net:443/',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    trustPayments: {
        dao: {
            token: 'passport_d056025fbea3c4700729c5b96b0ff97b',
            baseUrl: 'https://trust-payments.paysys.yandex.net/trust-payments',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 8000
        }
    },
    trustApi: {
        dao: {
            baseUrl: 'https://api.trust.yandex.net',
            maxRetries: 1,
            maxConnections: 100,
            retryAfter: 100,
            timeout: 200
        }
    },
    praktikum: {
        dao: {
            baseUrl: 'https://pierce.praktikum.yandex.ru',
            maxRetries: 5,
            maxConnections: 100,
            retryAfter: 100, // Milliseconds to wait before retrying
            timeout: 8000
        }
    },
    deleteData: {
        baseUrls: common.deleteDataTestingBaseUrls,
        dao: {
            maxRetries: 0,
            maxConnections: 100,
            retryAfter: 0, // Milliseconds to wait before retrying
            timeout: 1000
        }
    }
};

exports.langs = ['ru', 'uk', 'en', 'tr', 'id', 'fr', 'fi'];

exports.paths = {
    retpath: '/passport?mode=passport',
    basic: '/registration',
    static: '{{STATIC_PATH}}',
    blackbox: 'blackbox.yandex-team.ru',
    mda: 'pass-rc.yandex-team.ru',
    social_static: common.socialStatic,
    providers: 'http://social.yandex.ru/providers-domik.json',
    broker: 'https://social.yandex.%tld%/broker2/start',
    oauth: 'oauth-rc.yandex-team.%tld%',
    internal: 'passport-internal.yandex.ru',
    internalPort: '81',
    experiments: 'http://uaas.search.yandex.net/passport',
    avatar: {
        host: 'center.yandex-team.ru',
        pathname: '/api/v1/user/%login%/avatar/%size%.jpg',
        default_300: 'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-300',
        avatar_300: 'https://avatars.mdst.yandex.net/get-yapic/%avatar_id%/islands-300'
    },
    yasms: 'http://sms.passport.yandex.ru',
    unread: {
        host: 'export.yandex.%tld%',
        pathname: '/for/unread.xml'
    },
    loginStatusPath: '/auth/login-status.html',
    bigbro: {
        hostname: 'karma.yandex.net',
        port: '80'
    },
    help: {
        passport: 'https://wiki.yandex-team.ru/passport/'
    },
    logs: {
        graphite: '/var/log/yandex/passport-frontend/graphite.log',
        requests: '/var/log/yandex/passport-frontend/requests.log'
    },
    emailValidator: '//passport-rc.yandex-team.%tld%/profile/emails/',
    ysa: {
        static: 'https://ysa-static.passport.yandex.net',
        hostname: 'ysa.passport.yandex.net',
        port: '80'
    },
    embeddedauth: '//passport-rc.yandex-team.%tld%/passport?mode=embeddedauth',
    yamoney: null,
    mapsAPI: 'https://api-maps.yandex.ru/2.1/?lang=%lang%',
    yamoneyCards: 'https://money.yandex.%tld%/cards',
    tunePlaces: common.tunePlaces,
    marketAddresses: common.marketAddresses,
    staticMaps: common.staticMaps,
    authCustomsStatic: 'https://yastatic.net/s3/passport-auth-customs/',
    accountsUrl: '//api.passport.yandex.%tld%/all_accounts',
    yaPayLanding: common.yaPayLanding
};

exports.intranetPaths = {
    retpath: '/passport?mode=passport',
    blackbox: 'blackbox.yandex-team.ru',
    mda: 'pass.yandex-team.ru'
};

exports.brokerParams = {
    startUrl: '/auth/social/start',
    retpath: '/auth/i-social__closer.html',
    consumer: 'passport',
    popupName: 'passport_social',
    display: 'popup',
    place: 'fragment'
};

/**
 * Billing connection
 * @see https://wiki.yandex-team.ru/Balance/Simple
 */
exports.billing = {
    url: 'http://balance-xmlrpc.yandex.net:8002/simpleapi/xmlrpc',
    token: 'mobile_yastore_22f7f32c7bd262ba38b31e755127399c'
};

/**
 * @see /routes/metrics.js
 */
exports.metrics = {
    '/registration': '784657',
    '/auth': '784657',
    '/registration/mail': '10053691',
    '/profile/data': '84093838'
};

exports.restore = {
    feedback: 'https://feedback2.yandex.ru/passport/spprstr/',
    blocked: 'https://feedback2.yandex.ru/passport/blocked/'
};

exports.audioCaptcha = {
    whitelist: ['KZ', 'UA', 'BY', 'RU', 'TR']
};

/**
 * Log level for the logs
 * @type {string}
 */
exports.loglevel = 'INFO';
exports.multiauth = true;
exports.multiauthPinning = true;
exports.intranet = true;

exports.appPasswordsClientIdMapping = {
    // Haha, no application passwords for ya-team
};

exports.corsAllowed = [
    'https://passport.yandex-team.ru',
    'https://oauth-rc.yandex-team.ru',
    'https://oauth.yandex-team.ru',
    'https://tvm.yandex-team.ru'
];

exports.journalEventsLimits = {
    logLimit: 5,
    mapLimit: 999
};

exports.workspace = {
    zone: 'ws.yandex.%TLD%'
};

// Configs for security middlewares
exports.helmet = {
    csp: {
        directives: {
            defaultSrc: [CSP.NONE],
            styleSrc: [CSP.SELF, CSP.YASTATIC, CSP.UNSAFE_INLINE, CSP.UNSAFE_EVAL, CSP.S3_MDS, CSP.S3_MDST],
            scriptSrc: [
                CSP.SELF,
                CSP.YASTATIC,
                CSP.METRIC,
                CSP.FINGERPRINT,
                CSP.API_MAPS,
                CSP.SUGGEST_MAPS,
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.EXPORT_PREFIX + tld[1];
                },
                CSP.UNSAFE_EVAL,
                CSP.UNSAFE_INLINE,
                function(req, res) {
                    return `'nonce-${res.locals.nonce}'`; // CSPv2 nonce directive for inline scripts
                },
                CSP.BEATLE
            ],
            imgSrc: [
                CSP.SELF,
                CSP.YASTATIC,
                CSP.YSA_STATIC_PROD,
                CSP.YANDEX_ST,
                CSP.DATA,
                CSP.METRIC,
                CSP.API_MAPS,
                CSP.CAPTCHA,
                CSP.S3_MDS,
                CSP.S3_MDST,
                CSP.AVATARS_MDS,
                CSP.AVATARS_MDST,
                CSP.CLCK,
                CSP.MAPS,
                CSP.YAPIC,
                CSP.CENTER_YANDEX_TEAM,
                CSP.IMG_YANDEX_RU,
                CSP.STATIC_MAPS,
                CSP.BLOB,
                CSP.DOWNLOADER_YANDEX_PROD
            ],
            fontSrc: [CSP.SELF, CSP.YASTATIC],
            objectSrc: [CSP.YASTATIC],
            mediaSrc: [CSP.CAPTCHA, CSP.DATA],
            connectSrc: [
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.MAIL_PREFIX + tld[1];
                },
                CSP.SELF,
                CSP.TRUST,
                CSP.METRIC,
                CSP.SUGGEST_MAPS,
                CSP.YANDEX_RU,
                CSP.API_PASSPORT
            ],
            frameAncestors: [
                function(req) {
                    if (req.path !== '/auth/smarttv') {
                        return CSP.SELF;
                    }

                    return CSP.SELF;
                }
            ],
            frameSrc: [
                CSP.SELF,
                CSP.YANDEX_ST,
                CSP.BILLING_FRAME,
                CSP.MONEY_FRAME,
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return tld[1];
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.PASS_PREFIX_PROD + tld[1];
                },
                CSP.FORM_YANDEX
            ],
            childSrc: [
                CSP.SELF,
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return tld[1];
                },
                function(req) {
                    const tld = CSP.TLD_REGEXP.exec(req.hostname);

                    if (!tld) {
                        return null;
                    }

                    return CSP.PASS_PREFIX_PROD + tld[1];
                }
            ],
            reportUri: [
                (req) => {
                    return url.format({
                        protocol: 'https',
                        hostname: 'csp.yandex.net',
                        pathname: 'csp',
                        query: {
                            from: 'passport',
                            project: 'passport',
                            yandex_login: req.cookies.yandex_login,
                            yandexuid: req.cookies.yandexuid
                        }
                    });
                }
            ],
            manifestSrc: [CSP.SELF]
        },
        reportOnly: false
    },
    frameguard: 'DENY',
    noCache: {
        noEtag: true
    }
};

exports.experiments = common.experiments;

exports.links = common.links;

exports.secrets = {
    yamoney: common.yamoneySecret
};

exports.retries = common.retries;

exports.securityLevels = common.securityLevels;
exports.cloudAPIToken = common.cloudAPIToken;
exports.connectAPIToken = common.connectAPIToken;
exports.billingFrame = CSP.BILLING_FRAME;
exports.cspTldRegexp = CSP.TLD_REGEXP;
// https://wiki.yandex-team.ru/JandeksPoisk/TematicheskiePoiski/GeoPoisk/metrics/mapreqanslog/origin/
exports.geoCoderOrigin = 'maps-passport';
exports.ticketsFile = common.ticketsFile;
exports.neoPhonishPrefix = common.neoPhonishPrefix;
exports.ysaIdMap = common.ysaIdMap;
exports.signup = common.signup;
exports.sessguardDomains = common.sessguardDomains;
exports.otpSessionReissueInterval = common.otpSessionReissueInterval;
