# Как собрать пакет

Проверить, что проект проходит тесты — сделать `npm test`

В релизе проверить, что ветка не отстает от мастера (см. Я собираю пакет в Gitflow.md)

В корне проекта `dch -i`, в редакторе в новой записи в чейнджлог
 * Проверь версию (см. Как выбрать версию)
 * Проверь имя и емейл мейнтейнера (если приходится менять руками, см. "В первый раз")
 * Опиши изменения (см. Сбор чейнджлога)
 
Когда чейнджлог готов
 * Сохрани чейнджлог и выходи из редактора
 * Коммить и пушь изменения в чейнджлог: `git commit -am 'Build <версия билда>'; git push`
 
Тимсити
 * http://quigon.yandex.ru/project.html?projectId=PassportFrontend_Passport
 * Нажми Run в сборке Clientside.
 * В диалоге задай переменной Branch название ветки, которую нужно собрать
 * Жми Run build
 * Повтори операции для сборки Serverside
 
Для релизных пакетов (см. Releases.md)
 * Дождись сборки пакета и выкладки статики на ястатик
 * Зайди на http://c.yandex-team.ru/tickets/new?ticket[packages][0]=yandex-passport-frontend
 * Убедись, что в поле "ветка" написано testing (или prestable/stable, если можно катить в прод)
 * Выставь только что собранную версию в поле "версия" напротив пакета yandex-passport-frontend
 * В комментарий вставь чейнджлог 
 * Создай тикет и скопируй ссылку на него
 * В комментарий к релизному таску в стартреке вставь ссылку на кондукторный тикет



## Сбор чейнджлога

```bash
git log --pretty=oneline `git log --pretty=oneline --no-color | grep -iP 'NOTASK: Build' | head -1 | cut -d' ' -f1`.. | grep -P '([A-Z]+-\d+.*)' | cut -d' ' -f2- | sort | uniq | grep -P '^[A-Z]+-\d+'
```

Как это работает: из всех изменений начиная с последнего билда выбираем те, у которых коммент похож на описание таска.

 
 
## Как выбрать версию
Боевые релизы (на passport-test и в прод)
 * Для нового билда в текущем релизе делаем +1 к последней цифре (0.1.74-10 -> 0.1.74-11)
 * Для нового релиза пишем версию релиза (0.1.74 или 0.1.74-0)

Релизы для боксов, основое правило — не менять боевую версию
 * Для нового релиза, предназначенного для боксов дописываем идентификатор бокса к последнему билду (0.1.74-10 -> 0.1.74-10yastatic)
 * Для нового билда в релизе для боксов делаем +1 к последней цифре (0.1.74-10yastatic -> 0.1.74-10yastatic1)



## В первый раз

В .bashrc (или rc используемого шелла) пишем:
```bash
export DEBFULLNAME="Arseny Smoogly"
export DEBEMAIL="smoogly@yandex-team.ru"
alias dch='dch --distributor debian --distribution unstable --force-distribution'
```
