# Логгирование
Где и как писать логи, как за ними смотреть.
Disclaimer — это план на будущее, сейчас логи живут совсем не так.



## TODO
 * Что писать в log message?
 * Как указывать тип лога, помимо логлевела (запросы к разным апи, например)?
 * Как заводить мониторинги?
 * Что должно быть на графиках?
 * Где и когда смотреть на графики?



## Где и что писать в логи
В любой обработке эксцепшена должен быть critical, error или warn лог: try-catch, rejected promise, error-handler'ы.
В логе должно быть описание ошибки и трейс эксцепшена.

На любой границе сервисов, включая все запросы к апи и начало и конец обработки запроса пользователя,
должны быть описаны параметры запроса: урлы, опции, ответ ручки.

Все данные перед записью должны пройти через чистку, чтобы в логах не было
персональных данных и кук.

При желании написать console.log в это место нужно воткнуть и навсегда оставить debug или verbose лог.



## Как должен быть записан лог
 * Содержимое лога определяется минимальным логлевелом для текущего окружения: `require('plog').configure().minLevel(config.loglevel);`
 * Во всех окружениях, кроме дева, запись в логе должна быть в одну строчку, чтобы запись можно было целиком найти грепом.
 * Логи не должны содеражать control characters при записи в файл (никаких покрашенных логов в файлах).
 * Все записи в пределах одного запроса должны содержать одинаковый идентификатор (logId),
   чтобы по одной строчке из запроса можно было найти все остальные. И это не трек, потому что трек есть не всегда.
   Это касается всех запросов, которые пишутся в продакшен-лог: начиная с Info и важнее.
 * В каждой строчке лога должно быть указано время, когда произошло событие.
 * Для каждой записи должно быть возможно однозначно определить место в коде, откуда она была произведена.



## Логлевелы
Логлевел — важность события в логе.
В продакшен-лог нужно писать события начиная с Info и важнее.

### Critical
Лог для ошибки, после которой приложение не может продолжать обслуживать любые запросы.
Например: неправильный конфиг, неожиданное окружение.
Ошибка — критикал, если при её появлении нужно будить разработчика посреди ночи, чтобы её чинить как можно быстрее.

### Error
Ошибка, при которой конкретный запрос не может быть продолжен при наличии всех предварительных условий.
Например, не ответившая после нескольких ретраев ручка. Но не ответ ручки о плохих входных данных.
Ошибка — error, когда пользователь не может завершить действие из-за этой ошибки в приложении.
Наличие таких ошибок в логе должно быть поводом для беспокойства и поиска решения в следующем релизе.

### Warn
Любое неожиданное событие в процессе, не мешающее его продолжению.
Например, ретрай на ручке, отсутствие ответа при наличии дефолта или эксцепшен, отловленный при валидации формы,
после которого форма считается невалидной, но пользователь может попробовать заполнить поле по-другому.
Событие нужно логгировать как ворнинг, если цель пользователя не задета, но потенциально в этом месте может быть проблема.
Резкое возрастание таких ошибок в логе должно быть поводом разбираться с проблемой.

### Info
Информация о прохождении процесса через ключевые места.
Например, данные запроса от клиента в момент получения, данные запроса к ручке и т.д.
Событие будет информационным, если в случае Error'а по этому событию можно будет восстановить важные куски процесса.

### Debug
Информация почему было принято конкретное решение в этой точке процесса.
Например, попадание в конкретную ветку if'а или значение переменной, на основании которой сделано решение в ключевом месте рядом с Info

### Verbose
Мельчайшие детали, листинги переменных и объектов.
Например, данные шаблона перед отправкой в шаблонизатор.



## Мониторинги
За critical, error и warn событиями в логе нужно следить.
При наличии единственного критикала или резком росте error'ов
нужно поднять ответственных разработчиков и срочно чинить проблему.

При появлении error'ов в логах или резком росте количества warning'ов нужно искать причину
и при наличии причины в кодбазе фронтенда паспорта, эту причину нужно починить
хотфиксом или в следующем релизе в зависимости от серьезности ситуации.
