const babel = require('babel-core');
const jestPreset = require('babel-preset-jest');

module.exports = {
    process(src, filename) {
        if (babel.util.canCompile(filename)) {
            return babel.transform(src, {
                filename,
                presets: [jestPreset, 'es2015', 'react'],
                retainLines: true
            }).code;
        }
        return src;
    }
};
