import Enzyme from 'enzyme';
import Adapter from 'enzyme-adapter-react-16';
import React from 'react';

Enzyme.configure({adapter: new Adapter()});

const storage = {};

global.$ = require('jquery');
global.i18n = (params) => {
    if (typeof params === 'string') {
        return params;
    }

    const count = params.count;

    if (count === 0) {
        return params.none;
    }

    const lastNumber = count % 10;
    const lastNumbers = count % 100;

    if (lastNumber === 1 && lastNumbers !== 11) {
        return params.one;
    } else if (lastNumber > 1 && lastNumber < 5 && (lastNumbers < 10 || lastNumbers > 20)) {
        return params.some;
    }

    return params.many;
};
global.localStorage = {
    getItem: jest.fn((key) => {
        if (storage.hasOwnProperty(key)) {
            return storage[key];
        }

        return null;
    }),
    setItem: jest.fn((key, value) => {
        storage[key] = value;
    })
};

jest.mock('@components/Modal', () => ({
    Modal: () => <></>
}));
jest.mock('@components/Link', () => ({
    Link: () => <></>
}));
jest.mock('@components/Button', () => ({
    // eslint-disable-next-line
    Button: ({onClick}) => <button className='Button2' onClick={onClick} />
}));
jest.mock('@components/Popup', () => ({
    Popup: () => <></>
}));
jest.mock('@components/Checkbox', () => ({
    Checkbox: () => <></>
}));
jest.mock('@components/Input', () => ({
    // eslint-disable-next-line
    Input: ({onChange}) => <input onChange={onChange} />
}));
jest.mock('@components/Menu', () => ({
    Menu: () => <></>
}));
jest.mock('@components/Attach', () => ({
    Attach: () => <></>
}));
jest.mock('@components/Icon', () => ({
    Icon: () => <></>
}));
jest.mock('@components/Logo', () => ({
    Logo: () => <></>
}));

jest.mock('@components/RadioButton', () => ({
    RadioButton: () => <></>
}));
jest.mock('@components/Select', () => ({
    Select: () => <select className='Select2' />
}));
jest.mock('@components/Spin', () => ({
    Spin: () => <></>
}));
jest.mock('@components/TextArea', () => ({
    TextArea: () => <></>
}));
jest.mock('@components/Tumbler', () => ({
    Tumbler: () => <></>
}));
jest.mock('@components/User', () => ({
    User: () => <></>
}));
