module.exports = function(config) {
    config.set({
        basePath: './',
        frameworks: ['mocha', 'expect', 'sinon'],
        files: [
            'http://yandex.st/jquery/3.2.1/jquery.js',
            'http://yandex.st/underscore/1.5.2/underscore-min.js',

            // Globals
            'test/util/globals.js',

            // Extra assertions for expect.js
            'test/util/expect_assertions.js',
            'test/util/expect_assertion_tests.js',

            // Build
            'test/client/_build/nanoislands.js',
            'test/client/_build/blocks.js',

            // Initializing blocks
            'test/client/blocks/initBlocks.js',

            // Specs
            'test/client/blocks/**/*.js'
            // 'test/client/pages/**/**/*.js'
        ],
        preprocessors: {
            'test/client/_build/blocks.js': ['coverage']
        },
        singleRun: true,
        reporters: ['coverage', 'mocha'],
        port: 9876,
        colors: true,
        logLevel: config.LOG_INFO,
        browsers: ['PhantomJS'],
        captureTimeout: 60000,
        coverageReporter: {
            dir: 'coverageClient/',
            reporters: [
                {type: 'html', subdir: 'report-html'},
                {type: 'lcov', subdir: 'report-lcov'},
                {type: 'text-summary', subdir: '.', file: 'text-summary.txt'}
            ]
        }
    });
};
