/**
 * Naive interface checking implementation
 * @type {Interface}
 */
module.exports = require('inherit')({
    /**
     * Create the interface by providing the method names interface should support
     * @param {string...} supportedMethods  Method name with or without arity: 'someMethod', 'someMethodWithArity:2'
     * @constructor
     */
    // eslint-disable-next-line no-unused-vars
    __constructor: function(supportedMethods) {
        this.methods = Array.prototype.slice.call(arguments);
    },

    /**
     * Checks this interface is implemented by object
     * @param {Object} object
     * @returns {boolean}
     */
    implementedBy: function(object) {
        if (!object || typeof object !== 'object') {
            return false;
        }

        return require('lodash').every(this.methods, function(method) {
            var arity = null;

            if (method.indexOf(':') > -1) {
                var split = method.split(':', 2);

                method = split[0];
                arity = parseInt(split[1], 10);
            }

            if (typeof object[method] !== 'function') {
                return false;
            }

            return arity === null || object[method].length === arity;
        });
    }
});
