var _ = require('lodash');

/**
 * An executor for Actions
 *
 * @type {Executor}
 */
module.exports = require('inherit')({
    /**
     * Create an Executor with an array of Actions
     * @param {Action[]} actions    Actions to be executed
     * @constructor
     */
    __constructor: function(actions) {
        var assert = require('assert');

        assert(
            _.isArray(actions) &&
                actions.every(function(action) {
                    return action instanceof require('./action');
                }),
            'Executor should be instantiated with an array of Actions'
        );

        /**
         * An array of actions to be executed
         * @type {Action[]}
         * @private
         */
        this._actions = actions;
    },

    /**
     * Execute the actions
     *
     * @param {*...} [args]    Arguments to be applied to every call
     */
    run: function(args) {
        var actions = this._actions.map(function(action) {
            return action.execute.bind(action);
        });

        args = Array.prototype.slice.call(arguments);
        return require('when/sequence').apply(null, [actions].concat(args));
    }
});
