const inherit = require('inherit');

const HttpDAO = require('pdao/Http');
const papiAfisha = require('papi/Afisha');
const retryCondition = require('papi/Afisha/retryCondition');
const currentConfig = require('../../../configs/current');

module.exports = inherit(papiAfisha, {
    __constructor: function(logID, userTicket, serviceTicket, userVariables = {}) {
        const config = currentConfig.api.afisha.dao;

        const dao = new HttpDAO(
            logID,
            config.baseUrl,
            // 'http://0.0.0.0:1338', // for debug with 'core/passport/tools/afisha-gql-proxy.js serv'
            config.maxRetries,
            config.retryAfter,
            config.maxConnections,
            config.timeout,
            retryCondition(),
            false,
            false,
            config.agentOptions
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket,
            'X-Ya-User-Ticket': userTicket,
            'Content-type': 'application/json'
        });

        this.__base(logID, dao, userVariables);
    }
});
