const HttpDAO = require('pdao/Http');
const papiAntifraud = require('papi/Antifraud');
const retryCondition = require('papi/Antifraud/retryCondition');
const config = require('../../../configs/current');

module.exports = class AntifraudApi extends papiAntifraud {
    constructor(logID, serviceTicket) {
        const {baseUrl, maxRetries, retryAfter, maxConnections, timeout} = config.api.antifraud.dao;

        super(
            logID,
            new HttpDAO(
                logID,
                baseUrl,
                maxRetries,
                retryAfter,
                maxConnections,
                timeout,
                retryCondition(),
                false,
                false
            ).mixHeaders({
                'X-Ya-Service-Ticket': serviceTicket,
                'Content-type': 'application/json'
            })
        );
    }
};
