const HttpDAO = require('pdao/Http');
const papiAvatars = require('papi/Avatars');
const retryCondition = require('papi/Avatars/retryCondition');
const currentConfig = require('../../../configs/current');

class AvatarsApi extends papiAvatars {
    constructor(logID, serviceTicket) {
        const config = currentConfig.api.avatars.dao;

        const dao = new HttpDAO(
            logID,
            config.baseUrl,
            config.maxRetries,
            config.retryAfter,
            config.maxConnections,
            config.timeout,
            retryCondition(),
            true,
            false,
            config.agentOptions
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket
        });

        super(logID, dao);
    }
}

module.exports = AvatarsApi;
