const inherit = require('inherit');
const config = require('../../../configs/current');
const pdaoHttp = require('pdao/Http');
const papiBilling = require('papi/Billing');
const retryCondition = require('papi/Billing/retryCondition');

module.exports = inherit(papiBilling, {
    __constructor: function(logID) {
        const daoConfig = config.api.billing.dao;
        const HttpDAO = pdaoHttp;
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition()
        ).mixHeaders({
            'Content-type': 'application/json'
        });

        this.__base(logID, dao);
    }
});
