const inherit = require('inherit');
const config = require('../../../configs/current');
const pdaoHttp = require('pdao/Http');
const papiBillingInternal = require('papi/BillingInternal');
const retryCondition = require('papi/BillingInternal/retryCondition');

module.exports = inherit(papiBillingInternal, {
    __constructor: function(logID, serviceTicket) {
        const daoConfig = config.api.billingInternal.dao;
        const HttpDAO = pdaoHttp;
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition()
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket,
            'Content-type': 'application/json'
        });

        this.__base(logID, dao);
    }
});
