const HttpDAO = require('pdao/Http');
const papiBnpl = require('papi/Bnpl');
const retryCondition = require('papi/Bnpl/retryCondition');
const config = require('../../../configs/current');

module.exports = class BnplApi extends papiBnpl {
    constructor(logID, uid, serviceTicket) {
        const {baseUrl, maxRetries, retryAfter, maxConnections, timeout} = config.api.bnpl.dao;

        super(
            logID,
            new HttpDAO(logID, baseUrl, maxRetries, retryAfter, maxConnections, timeout, retryCondition()).mixHeaders({
                'X-Ya-Service-Ticket': serviceTicket,
                'X-Yandex-Uid': uid,
                'Content-type': 'application/json'
            })
        );
    }
};
