var config = require('../../../configs/current');
var inherit = require('inherit');
var pdaoHttp = require('pdao/Http');
var papiCloud = require('papi/Cloud');
var retryCondition = require('papi/Cloud/retryCondition');

module.exports = inherit(papiCloud, {
    __constructor: function(logID, uid, serviceTicket, userTicket) {
        var daoConfig = config.api.cloud.dao;
        var HttpDAO = pdaoHttp;
        var dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition(),
            false,
            false, // не примещиваем content-type application/x-www-form-urlencoded; charset=utf-8
            daoConfig.agentOptions
        ).mixHeaders({
            'X-Uid': uid,
            'X-Ya-Service-Ticket': serviceTicket,
            'X-Ya-User-Ticket': userTicket,
            'Content-type': 'application/json'
        });

        this.__base(logID, dao);
    }
});
