var config = require('../../../configs/current');
var util = require('util');
var inherit = require('inherit');
var pdaoHttp = require('pdao/Http');
var papiConnect = require('papi/Connect');
var retryCondition = require('papi/Connect/retryCondition');

module.exports = inherit(papiConnect, {
    __constructor: function(logID, ip, uid) {
        var daoConfig = config.api.connect.dao;
        var HttpDAO = pdaoHttp;
        var mixHeaders = {
            Authorization: util.format('token %s', config.connectAPIToken),
            'X-USER-IP': ip,
            'Content-type': 'application/json'
        };
        var dao = null;

        if (uid) {
            mixHeaders['X-UID'] = uid;
        }

        dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition(),
            false,
            false, // не примещиваем content-type application/x-www-form-urlencoded; charset=utf-8
            daoConfig.agentOptions
        ).mixHeaders(mixHeaders);

        this.__base(logID, dao);
    }
});
