const HttpDAO = require('pdao/Http');
const DeleteDataIot = require('papi/DeleteData');
const retryCondition = require('papi/DeleteData/retryCondition');
const config = require('../../../configs/current');

module.exports = class extends DeleteDataIot {
    constructor(baseUrl, logID, userTicket, serviceTicket, serviceName) {
        const {maxRetries, timeout, retryAfter, agentOptions, maxConnections} = config.api.deleteData.dao;

        super(
            logID,
            new HttpDAO(
                logID,
                baseUrl,
                maxRetries,
                retryAfter,
                maxConnections,
                timeout,
                retryCondition,
                false,
                false,
                agentOptions,
                {},
                serviceName
            ).mixHeaders({
                'X-Ya-Service-Ticket': serviceTicket,
                'X-Ya-User-Ticket': userTicket,
                'Content-type': 'application/json'
            })
        );
    }
};
