var config = require('../../../configs/current');
var inherit = require('inherit');
var pdaoHttp = require('pdao/Http');
var papiCloud = require('papi/Documents');
var retryCondition = require('papi/Documents/retryCondition');

module.exports = inherit(papiCloud, {
    __constructor: function(logID, uid, serviceTicket, userTicket) {
        var daoConfig = config.api.documents.dao;
        var HttpDAO = pdaoHttp;
        var dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition(),
            true,
            false, // не примещиваем content-type application/x-www-form-urlencoded; charset=utf-8
            daoConfig.agentOptions
        ).mixHeaders({
            'X-Uid': uid,
            'X-Ya-Service-Ticket': serviceTicket,
            'X-Ya-User-Ticket': userTicket
        });

        this.__base(logID, dao);
    }
});
