const HttpDAO = require('pdao/Http');
const FamilyPayPapi = require('papi/FamilyPay');
const retryCondition = require('papi/FamilyPay/retryCondition');
const config = require('../../../configs/current');

module.exports = class FamilyPayApi extends FamilyPayPapi {
    constructor(logID, trackId, userTicket, serviceTicket) {
        const {baseUrl, maxRetries, retryAfter, maxConnections, timeout} = config.api.familypay.dao;

        super(
            logID,
            new HttpDAO(
                logID,
                baseUrl,
                maxRetries,
                retryAfter,
                maxConnections,
                timeout,
                retryCondition(),
                false,
                false
            ).mixHeaders({
                'X-Yandex-Track-Id': trackId,
                'X-Ya-Service-Ticket': serviceTicket,
                'X-Ya-User-Ticket': userTicket,
                'Content-type': 'application/json'
            })
        );
    }
};
