const config = require('../../../configs/current');
const inherit = require('inherit');
const pdaoHttp = require('pdao/Http');
const papiGeo = require('papi/Geo');
const retryCondition = require('papi/Geo/retryCondition');

module.exports = inherit(papiGeo, {
    __constructor(logID, serviceTicket) {
        const HttpDAO = pdaoHttp;
        const daoConfig = config.api.geo.dao;
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition()
        )
            .setEncoding('buffer')
            .setResponseType('buffer')
            .mixHeaders({
                'X-Ya-Service-Ticket': serviceTicket,
                'Content-type': 'application/json'
            });

        this.__base(logID, dao);
    }
});
