const HttpDAO = require('pdao/Http');
const papiIot = require('papi/Iot');
const retryCondition = require('papi/Iot/retryCondition');
const currentConfig = require('../../../configs/current');

class IotApi extends papiIot {
    constructor(logID, userTicket, serviceTicket) {
        const config = currentConfig.api.iot.dao;

        const dao = new HttpDAO(
            logID,
            config.baseUrl,
            // 'http://0.0.0.0:1338', // for debug with 'core/passport/tools/afisha-gql-proxy.js serv'
            config.maxRetries,
            config.retryAfter,
            config.maxConnections,
            config.timeout,
            retryCondition(),
            false,
            false,
            config.agentOptions
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket,
            'X-Ya-User-Ticket': userTicket,
            'Content-type': 'application/json'
        });

        super(logID, dao);
    }
}

module.exports = IotApi;
