const HttpDAO = require('pdao/Http');
const papiKinopoisk = require('papi/Kinopoisk');
const retryCondition = require('papi/Kinopoisk/retryCondition');
const currentConfig = require('../../../configs/current');

class KinopoiskApi extends papiKinopoisk {
    constructor(logID, userAgent, userTicket, serviceTicket) {
        const config = currentConfig.api.kinopoisk.dao;

        const dao = new HttpDAO(
            logID,
            config.baseUrl,
            config.maxRetries,
            config.retryAfter,
            config.maxConnections,
            config.timeout,
            retryCondition(),
            false,
            false,
            config.agentOptions
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket,
            'X-Ya-User-Ticket': userTicket,
            'User-Agent': userAgent,
            'Content-type': 'application/json'
        });

        super(logID, dao);
    }
}

module.exports = KinopoiskApi;
