require('papi/OAuth').setAppPasswordsClientIdMapping(require('../../../configs/current').appPasswordsClientIdMapping);

module.exports = require('inherit')(require('papi/OAuth'), {
    __constructor: function(logID, rawHeaders, lang, uid) {
        var daoConfig = require('../../../configs/current').api.oauth.dao;
        var HttpDAO = require('pdao/Http');
        var dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            require('papi/OAuth/retryCondition')(daoConfig.retryCodes)
        );

        this.__base(logID, dao, 'passport-frontend', rawHeaders, lang, uid);
    }
});
