var assert = require('assert');
var inherit = require('inherit');
var config = require('../../../configs/current');
var HttpDAO = require('pdao/Http');
var PapiPassport = require('papi/Passport');
var retryCondition = require('papi/Passport/retryCondition');
var PLog = require('plog');
var _ = require('lodash');

module.exports = inherit(
    PapiPassport,
    {
        __constructor: function(logID, headers, lang, uid) {
            var daoConfig = config.api.passport.dao;
            var dao = new HttpDAO(
                logID,
                daoConfig.baseUrl,
                daoConfig.maxRetries,
                daoConfig.retryAfter,
                daoConfig.maxConnections,
                daoConfig.timeout,
                retryCondition(daoConfig.retryCodes),
                undefined,
                undefined,
                daoConfig.agentOptions,
                config.defaults.headers
            );
            var consumer = config.defaults.qs.consumer;

            this.__base(logID, dao, headers, consumer, lang, uid);
        }
    },
    {
        transformHeaders: (function() {
            var specialTransformations = {
                'x-real-ip': 'ya-consumer-client-ip',
                authorization: 'ya-consumer-authorization',
                'x-yproxy-header-ip': 'x-yproxy-header-ip',
                'x-real-scheme': 'ya-consumer-client-scheme',
                'X-Ya-Service-Ticket': 'X-Ya-Service-Ticket'
            };

            var explicitlyEmpty = ['cookie', 'accept-language', 'user-agent'];
            var prefix = 'ya-client-';

            return function(headers, logID) {
                assert(_.isObjectLike(headers), 'Headers should be a dictionary');

                headers = _.transform(
                    headers,
                    function(headers, value, header) {
                        if (typeof value !== 'string') {
                            PLog.warn()
                                .logId(logID)
                                .type('PapiPassport.transformHeaders')
                                .write(`Wrong header ${header} value type: ${typeof value}, ${_.escape(value)}`);
                        }

                        value = value && String(value).replace(/[^ -~]+/g, '');

                        if (header in specialTransformations) {
                            headers[specialTransformations[header]] = value;
                        } else if (header.indexOf(prefix) !== 0) {
                            headers[prefix + header] = value;
                        }
                    },
                    {}
                );

                explicitlyEmpty.forEach(function(explicitlyEmpty) {
                    var header = prefix + explicitlyEmpty;

                    if (!headers[header]) {
                        headers[header] = '';
                    }
                });

                return headers;
            };
        })()
    }
);
