const inherit = require('inherit');
const config = require('../../../configs/current');
const pdaoHttp = require('pdao/Http');
const papiBilling = require('papi/PlusLanding');
const retryCondition = require('papi/PlusLanding/retryCondition');

module.exports = inherit(papiBilling, {
    __constructor: function(logID, userTicket, serviceTicket, userIp) {
        const daoConfig = config.api.plusLanding.dao;
        const HttpDAO = pdaoHttp;
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition()
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket,
            'X-Ya-User-Ticket': userTicket,
            'X-User-Ip': userIp,
            'Content-type': 'application/json'
        });

        this.__base(logID, dao);
    }
});
