const HttpDAO = require('pdao/Http');
const papiPraktikum = require('papi/Praktikum');
const retryCondition = require('papi/Praktikum/retryCondition');
const config = require('../../../configs/current');

class PraktikumApi extends papiPraktikum {
    constructor(logID, serviceTicket) {
        const {baseUrl, maxRetries, retryAfter, maxConnections, timeout, agentOptions} = config.api.praktikum.dao;

        const dao = new HttpDAO(
            logID,
            baseUrl,
            maxRetries,
            retryAfter,
            maxConnections,
            timeout,
            retryCondition(),
            true,
            false,
            agentOptions
        ).mixHeaders({
            'X-Ya-Service-Ticket': serviceTicket
        });

        super(logID, dao);
    }
}

module.exports = PraktikumApi;
