const HttpDAO = require('pdao/Http');
const PapiTrustApi = require('papi/TrustApi');
const retryCondition = require('papi/TrustApi/retryCondition');
const config = require('../../../configs/current');

module.exports = class TrustApi extends PapiTrustApi {
    constructor(logID, userTicket, serviceTicket) {
        const {baseUrl, maxRetries, retryAfter, maxConnections, timeout} = config.api.trustApi.dao;

        super(
            logID,
            new HttpDAO(logID, baseUrl, maxRetries, retryAfter, maxConnections, timeout, retryCondition()).mixHeaders({
                'X-Ya-Service-Ticket': serviceTicket,
                'X-Ya-User-Ticket': userTicket,
                'Content-type': 'application/json'
            })
        );
    }
};
