const HttpDAO = require('pdao/Http');
const PapiTrustPayments = require('papi/TrustPayments');
const retryCondition = require('papi/TrustPayments/retryCondition');
const config = require('../../../configs/current');

module.exports = class TrustPaymentsApi extends PapiTrustPayments {
    constructor(logID, uid) {
        const {baseUrl, maxRetries, retryAfter, maxConnections, timeout, token} = config.api.trustPayments.dao;

        super(
            logID,
            new HttpDAO(logID, baseUrl, maxRetries, retryAfter, maxConnections, timeout, retryCondition()).mixHeaders({
                'X-Service-Token': token,
                'X-Uid': uid,
                'Content-type': 'application/json'
            })
        );
    }
};
