const PController = require('./');
const {SERVICE_ALIASES} = require('../tvm');

module.exports = (app) => {
    app.all('*', [
        // create controller
        (req, res, next) => {
            req._controller = req._controller || new PController(req, res, req.logID, SERVICE_ALIASES);

            next();
        },
        (req, res, next) => {
            const controller = req._controller;

            let domain = `.yandex.${controller.getTld()}`;

            if (process.env.INTRANET === 'intranet') {
                domain = '.yandex-team.ru';
            }

            if (!controller.getCookie('yandexuid')) {
                controller.setCookie('yandexuid', controller.generateYandexuid(), {
                    domain,
                    secure: true,
                    maxAge: 315360000000 // 10 лет в миллисекундах
                });
            }

            if (!controller.getCookie('uniqueuid')) {
                const cookieOpts = {
                    sameSite: 'lax',
                    httpOnly: true,
                    secure: true,
                    maxAge: 315360000000 // 10 лет в миллисекундах
                };

                if (
                    [
                        '/auth/smarttv/',
                        '/auth/smarttv',
                        '/auth/update/',
                        '/auth/update',
                        '/profile/public/',
                        '/profile/public'
                    ].includes(req.path)
                ) {
                    cookieOpts.sameSite = 'None';
                }

                controller.setCookie('uniqueuid', controller.generateYandexuid(), cookieOpts);
            }

            res._yandexuid = controller.getCookie('yandexuid');

            next();
        }
    ]);
};
