const config = require('../configs/current');
const isLocalDev = config.version === 'local';
const configCommon = require('../configs/common');
const geobase = isLocalDev ? {} : require('@yandex-int/yandex-geobase').default;

const mock = {
    getRegionIdByIp: 213,
    getRegionById: {
        id: 213,
        type: 6,
        parent_id: 1,
        geo_parent_id: 0,
        capital_id: 0,
        name: 'Москва',
        native_name: '',
        iso_name: 'RU-MOW',
        is_main: true,
        en_name: 'Moscow',
        short_en_name: 'MSK',
        phone_code: '495 499',
        zip_code: '',
        position: 0,
        population: 12506468,
        synonyms: 'Moskau, Moskva',
        latitude: 55.753215,
        longitude: 37.622504,
        latitude_size: 0.878654,
        latitiude_size: 0.878654,
        longitude_size: 1.164423,
        zoom: 10,
        tzname: 'Europe/Moscow',
        official_languages: 'ru',
        widespread_languages: 'ru',
        services: ['bs', 'yaca', 'weather', 'afisha', 'maps', 'tv', 'ad', 'etrain', 'subway', 'delivery', 'route']
    },
    getLinguistics: {
        ablative_case: '',
        accusative_case: 'Москву',
        dative_case: 'Москве',
        directional_case: '',
        genitive_case: 'Москвы',
        instrumental_case: 'Москвой',
        locative_case: '',
        nominative_case: 'Москва',
        preposition: 'в',
        prepositional_case: 'Москве'
    },
    getCountryId: 225,
    getIpTraits: {
        region_id: 213,
        asn_list: '13238',
        isp_name: 'yandex llc',
        org_name: 'yandex llc',
        yandex_net: true,
        yandex_staff: true
    }
};

let ipreg;

let ipregLookup;

try {
    ipreg = require(configCommon.ipreg.lib);
    ipregLookup = new ipreg.Lookup(configCommon.ipreg.lookup);
} catch (e) {
    ipregLookup = {
        getNet: () => {}
    };
}

let lookup;

if (process.versions && process.versions.modules > 48 && !isLocalDev) {
    lookup = geobase.v6({
        geobaseData: '/var/cache/geobase/geodata6.bin'
    });
} else {
    const lookup5 = isLocalDev
        ? {}
        : geobase.v5({
              geobaseData: '/var/cache/geobase/geodata5.bin'
          });

    lookup = Object.assign({}, lookup5, {
        getRegionIdByIp: isLocalDev ? () => mock.getRegionIdByIp : lookup5.regionId.bind(lookup5),
        getRegionById: isLocalDev ? () => mock.getRegionById : lookup5.regionById.bind(lookup5),
        getLinguistics: isLocalDev ? () => mock.getLinguistics : lookup5.linguistics.bind(lookup5),
        getCountryId: isLocalDev ? () => mock.getCountryId : lookup5.findCountryId.bind(lookup5),
        getIpTraits: isLocalDev ? () => mock.getIpTraits : ipregLookup.getNet.bind(ipregLookup)
    });
}

module.exports = lookup;
