var cache = require('./messages.json');
var config = require('../../configs/current');
var locs = require('../../loc/auth.json');
var _ = require('lodash');
var util = require('util');
var langs = config.langs;

/* jshint -W079 */
var i18n = {};

langs.forEach(function(lang) {
    i18n[lang] = require('vm').runInNewContext(
        require('fs').readFileSync(`./lib/tanker/tanker.dynamic.${lang}.js`, 'utf-8')
    );
});

exports.get = function(code, language) {
    var lang = (language && langs[langs.indexOf(language)]) || 'ru';
    //messages = cache[lang] || (cache[lang] = require('./messages.' + lang + '.js').messages);
    var messages = cache[lang]['Errors'];

    return messages[code];
};

exports.processErrors = function(errors, lang, data) {
    var loc = locs[lang || 'ru'];
    var resultErrors = [];
    var login = (data && data.login) || '';
    var errIds = {
        'password.not_matched': 'ErrorsTexts.badlog',
        'password.not_matched.2fa': 'ErrorsTexts.badlog_2fa',
        'account.disabled': 'ErrorsTexts.badlog_blocked',
        'account.not_found': 'ErrorsTexts.deleted',
        'account.disabled_on_deletion': 'ErrorsTexts.deleted',
        'account.disabled_with_money': 'ErrorsTexts.deleted',
        'account.registration_limited': 'import.sms_limit_exceeded',
        internal: 'ErrorsTexts.internal',
        retry: 'ErrorsTexts.retry',
        'backend.blackbox_failed': 'ErrorsTexts.auth_try_again',
        'backend.yasms_failed': 'ErrorsTexts.auth_try_again',
        'backend.database_failed': 'ErrorsTexts.auth_try_again',
        'backend.redis_failed': 'ErrorsTexts.auth_try_again',
        'login.invalid_format': 'ErrorsTexts.nodomain',
        'domain.not_hosted': 'ErrorsTexts.domainnotfound',
        'user.not_verified': 'field_human-confirmation_errors_unconfirmed',
        'sessionid.overflow': 'ErrorsTexts.sessionidoverflow',
        'account.compromised': 'ErrorsTexts.account_compromised',
        'session.invalid': 'session_invalid'
    };

    var mendIds = {
        'password.not_matched': 'creg_misspasswd',
        'password.not_matched.2fa': 'creg_misspasswd_2fa',
        'account.disabled': 'disabled',
        'account.not_found': 'deleted',
        'account.disabled_on_deletion': 'deleted',
        'account.disabled_with_money': 'deleted',
        internal: 'crap',
        'session.invalid': 'session_invalid_mend',
        'sessionid.overflow': 'MendTexts.sessionidoverflow'
    };

    var skip = [
        'sessionid.invalid',
        'service.invalid',
        'password.long',
        'password.short',
        'password.weak',
        'password.prohibitedsymbols',
        'password.likelogin',
        'password.equals_previous',
        'password.found_in_history',
        'answer.long',
        'question.long',
        'question.inconsistent',
        'captcha.required',
        'captcha.incorrect',
        'captcha.captchalocate',
        'account.auth_passed',
        'phone.required',
        'phone_secure.bound_and_confirmed',
        'password.likephonenumber'
    ];

    var internal = [
        'auth.error',
        'ip.empty',
        'host.empty',
        'scheme.empty',
        'cookie.empty',
        'useragent.empty',
        'exception.unhandled',
        'track.not_found',
        'track_id.empty',
        'track_id.invalid',
        'track.invalid_state',
        'consumer.empty',
        'consumer.invalid',
        'action.not_required'
    ];

    _.forEach(errors, function(val) {
        var code = val;
        var errId = val;

        if (skip.indexOf(val) !== -1) {
            return true;
        }

        if (internal.indexOf(val) !== -1) {
            errId = 'internal';
        }

        if (!errIds[errId]) {
            errId = 'internal';
        }

        var error = {
            code: code,
            // TODO: проверки на наличие всех полей
            msg: loc['Errors'][errIds[errId]]
        };

        if (mendIds[errId]) {
            if (util.isArray(mendIds[errId])) {
                var res = [];

                _.forEach(mendIds[errId], function(id) {
                    res.push(loc['Mend'][id].replace('%1', login));
                });
                error.mend = res.join(' ');
            } else {
                // TODO: проверки на наличие всех полей
                error.mend = loc['Mend'][mendIds[errId]].replace('%1', login);
            }
        }

        resultErrors.push(error);
    });

    return resultErrors;
};
