/**
 * DEPRECATED.
 * Use ./field.js and ./form.js instead.
 */

var _ = require('lodash');
var when = require('when');

function normalize(str) {
    var re = /\s+/;

    return (
        (str &&
            String(str)
                .split(re)
                .join(' ')
                .trim()) ||
        str
    );
}

var PassportForm = function(opts) {
    this.body = opts.body;
    this.api = opts.api;
    this.names = opts.names;
    this.required = opts.required;

    this.errors = [];
    this.needValidation = Boolean(this.body.track_id);
};

PassportForm.prototype.doValidation = function() {
    var deferred = when.defer();
    var api = this.api;
    var names = this.names;
    var body = this.body;
    var hash = {};
    var required = this.required;
    var asyncChecks = [];
    var errors = this.errors;

    function addError(controlName, code) {
        errors.push({
            control: controlName,
            code: code
        });
    }

    _.each(names, function(name) {
        if (name === 'password' || name === 'password_confirm') {
            hash[name] = body[name];
        } else {
            hash[name] = normalize(body[name]);
        }
    });

    _(required).each(function(name) {
        if (typeof hash[name] === 'undefined' || hash[name] === '') {
            addError(name, 'missingvalue');
        }
    });

    if (hash['password_confirm'] && hash['password'] && hash['password'] !== hash['password_confirm']) {
        addError('password_confirm', 'notequal');
    }

    if (hash['hint_question_id'] && hash['hint_question_id'] === '0') {
        addError('hint_question_id', 'missingvalue');
    }

    if (hash['hint_question_id'] && hash['hint_question_id'] === '99') {
        if (!hash['hint_question'] || hash['hint_question'] === '') {
            addError('hint_question', 'missingvalue');
        }
    }

    if (hash['login']) {
        asyncChecks.push(
            api.validateLogin({
                login: hash['login'],
                is_lite: hash['is_lite']
            })
        );
    }

    if (hash['password']) {
        asyncChecks.push(
            api.validatePassword({
                login: hash['login'],
                password: hash['password']
            })
        );
    }

    if (hash['phone_number']) {
        asyncChecks.push(
            api.validatePhone({
                phone_number: hash['phone_number']
            })
        );
    }

    if (hash['answer']) {
        asyncChecks.push(
            api.captchaCheck({
                key: hash['key'],
                answer: hash['answer']
            })
        );
    }

    if (hash['hint_answer']) {
        asyncChecks.push(
            api.validateHint({
                hint_answer: hash['hint_answer'],
                hint_question: hash['hint_question'],
                hint_question_id: hash['hint_question_id']
            })
        );
    }

    if (asyncChecks.length) {
        when.all(asyncChecks).then(
            function(results) {
                _(results).each(function(field) {
                    var body = field.body;
                    var name = field.field;

                    if (!body) {
                        throw new Error('Validation trouble');
                    }

                    if (name === 'captcha' && !body.correct) {
                        addError('answer', 'incorrect');
                        return true;
                    }

                    if (body.validation_errors) {
                        _(body.validation_errors).each(function(error) {
                            addError(error.field, error.code);
                        });
                    }
                });

                if (errors.length) {
                    deferred.reject(errors);
                } else {
                    deferred.resolve(hash);
                }
            },
            function(errors) {
                deferred.reject(errors);
            }
        );
    } else {
        if (errors.length) {
            deferred.reject(errors);
        } else {
            deferred.resolve();
        }
    }

    return deferred.promise;
};

PassportForm.prototype.loadErrors = function(controls, errors) {
    _.each(errors, function(error) {
        var controlName = error.control;
        var code = error.code;
        var control = _.filter(controls, {name: controlName})[0];

        if (control) {
            _.each(control.error, function(error) {
                if (error.code === code) {
                    error.active = true;
                }
            });
        }
    });

    return when.resolve(controls);
};

PassportForm.prototype.loadContext = function() {
    var deferred = when.defer();
    var api = this.api;
    var names = this.names;
    var body = this.body;

    when.join(api.params('language'), api.getQuestions()).then(
        function(values) {
            var lang = values[0].body.language || 'ru';
            var questions = values[1].body.questions;
            var controls = _.clone(require(`./template.${lang}.js`), true);
            var result = [];

            _.each(controls, function(control) {
                var name = control.name;

                if (name === 'hint_question_id') {
                    control.option = questions;
                }

                if (!(names.indexOf(name) !== -1 || body[name])) {
                    return true;
                }

                if (name === 'password' || name === 'password_confirm') {
                    control.value = body[name];
                } else {
                    control.value = normalize(body[name]);
                }

                result.push(control);
            });

            deferred.resolve(result);
        },
        function(err) {
            deferred.reject(err);
        }
    );

    return deferred.promise;
};

PassportForm.prototype.process = function() {
    var deferred = when.defer();
    var self = this;

    if (self.needValidation) {
        self.doValidation().then(
            function(result) {
                deferred.resolve({form: {}, validBody: result, isValid: true});
            },
            function(errors) {
                self.loadContext().then(
                    function(controls) {
                        self.loadErrors(controls, errors).then(function(controls) {
                            var form = {
                                control: controls
                            };

                            deferred.resolve({form: form, isValid: false});
                        });
                    },
                    function(error) {
                        deferred.reject(error);
                    }
                );
            }
        );
    } else {
        self.loadContext().then(
            function(controls) {
                var form = {
                    control: controls
                };

                deferred.resolve({form: form});
            },
            function(error) {
                deferred.reject(error);
            }
        );
    }

    return deferred.promise;
};

module.exports = function(options) {
    var optional = (options && options.optional) || ['hint_question', 'phone_number', 'submit', 'language'];
    var required = (options && options.required) || [
        'track_id',
        'login',
        'firstname',
        'lastname',
        'password',
        'password_confirm',
        'hint_question_id',
        'hint_answer',
        'key',
        'answer',
        'eula_accepted'
    ];

    return function(req, res, next) {
        var pform = new PassportForm({
            api: req.api,
            body: req.body,
            names: _.union(optional, required),
            required: required
        });

        pform.process().then(
            function(results) {
                res.locals.form = results.form;
                req.validBody = results.validBody;
                req.formIsValid = results.isValid;
                next();
            },
            function(error) {
                next(error);
            }
        );
    };
};
