const serialize = require('serialize-javascript');

module.exports.errorCounterInit = function errorCounterInit(config) {
    const opts = serialize(
        {
            slots: config.slots,
            reqid: config.requestId,
            project: 'passport',
            page: config.page,
            env: process.env.NODE_ENV === 'rc' ? 'prestable' : process.env.NODE_ENV,
            platform: config.platform,
            version: config.version,
            region: config.regionId,
            yandexuid: config.yandexuid,
            referrer: config.referrer,
            experiments: config.experiments,
            preventError: false,
            unhandledRejection: true,
            uncaughtException: true,
            debug: process.env.NODE_ENV === 'development',
            initTimestamp: +new Date()
        },
        {
            isJSON: true
        }
    );

    return String(`
        Ya.Rum.initErrors(${opts});
    `).replace(/\n|\s{2,}/g, '');
};
