const fs = require('fs');
const path = require('path');
const rumInit = require('./init').rumInit;
const errorCounterInit = require('./error-counter-init').errorCounterInit;

const files = [
    // rum-counter
    path.resolve(__dirname, '../../node_modules/@yandex-int/rum-counter/dist/inline/interface.min.js'),
    path.resolve(__dirname, '../../node_modules/@yandex-int/rum-counter/dist/inline/io.min.js'),
    path.resolve(__dirname, '../../node_modules/@yandex-int/rum-counter/dist/inline/longtask.min.js'),
    path.resolve(__dirname, '../../node_modules/@yandex-int/rum-counter/dist/bundle/send.min.js'),
    // error-counter
    path.resolve(__dirname, '../../node_modules/@yandex-int/error-counter/dist/interfaceOverRum.min.js'),
    path.resolve(__dirname, '../../node_modules/@yandex-int/error-counter/dist/implementation.min.js'),
    path.resolve(__dirname, '../../node_modules/@yandex-int/error-counter/dist/filters.min.js')
];

const readFileOptions = {encoding: 'utf8'};
const readFile = (path, options) =>
    new Promise((resolve, reject) => {
        fs.readFile(path, options, (err, data) => {
            if (err) {
                return reject(err);
            }
            return resolve(data);
        });
    });

const getScripts = () => {
    return new Promise((resolve, reject) => {
        if (this.script) {
            return resolve(this.script);
        }

        const promises = [];

        files.forEach((item) => promises.push(readFile(item, readFileOptions)));

        Promise.all(promises)
            .then((response) => {
                const script = response.join('');

                this.script = script;
                resolve(script);
            })
            .catch(reject);
    });
};

module.exports.getRumScripts = (config) => {
    return new Promise((resolve, reject) => {
        getScripts()
            .then((script) => {
                resolve([script, errorCounterInit(config), rumInit(config)].join(''));
            })
            .catch(reject);
    });
};
