const serialize = require('serialize-javascript');

module.exports.rumInit = function rumInit(config) {
    const opts = serialize(
        {
            beacon: true,
            clck: 'https://yandex.ru/clck/click',
            slots: config.slots,
            reqid: config.requestId
        },
        {
            isJSON: true
        }
    );
    const adds = serialize(
        {
            region: config.regionId,
            rum_id: config.rumId,
            '-project': 'passport',
            '-page': config.page,
            '-env': process.env.NODE_ENV === 'rc' ? 'prestable' : process.env.NODE_ENV,
            '-platform': config.platform,
            '-version': config.version,
            experiments: config.experiments
        },

        {
            isJSON: true
        }
    );

    return String(`
        Ya.Rum.init(${opts}, ${adds});
        Ya.Rum.observeDOMNode('2876', '.layout');
    `).replace(/\n|\s{2,}/g, '');
};
