const sidsLoc = require('../../loc/sids.json');
const id = require('uuid');

function getSidDescription(subscription, lang, tld) {
    const sids = [
        {
            sid: 2,
            name: 'mail',
            list: 'main',
            url: 'https://mail.yandex.%tld%'
        },
        {
            sid: 4,
            name: 'narod',
            list: 'secondary',
            url: 'https://narod.yandex.%tld%'
        },
        {
            sid: 5,
            name: 'fotki',
            list: 'main',
            url: 'https://fotki.yandex.%tld%'
        },
        {
            sid: 14,
            name: 'direct',
            list: 'main',
            url: 'https://direct.yandex.%tld%'
        },
        {
            sid: 19,
            name: 'billing',
            list: 'main',
            url: 'https://balance.yandex.%tld%'
        },
        {
            sid: 20,
            name: 'money',
            list: 'main',
            url: 'https://money.yandex.%tld%'
        },
        {
            sid: 24,
            name: 'rsya',
            list: 'main',
            url: 'https://partners.yandex.%tld%'
        },
        {
            sid: 25,
            name: 'market',
            list: 'main',
            url: 'https://market.yandex.%tld%'
        },
        {
            sid: 29,
            name: 'tvprogramma',
            list: 'secondary',
            url: 'https://tv.yandex.%tld%'
        },
        {
            sid: 30,
            name: 'afisha',
            list: 'secondary',
            url: 'https://afisha.yandex.%tld%'
        },
        {
            sid: 31,
            name: 'calendar',
            list: 'secondary',
            url: 'https://calendar.yandex.%tld%'
        },
        {
            sid: 39,
            name: 'video',
            list: 'secondary',
            url: 'https://video.yandex.%tld%'
        },
        {
            sid: 47,
            name: 'webmaster',
            list: 'secondary',
            url: ''
        },
        {
            sid: 48,
            name: 'metrika',
            list: 'main',
            url: 'https://metrika.yandex.%tld%'
        },
        {
            sid: 49,
            name: 'maps',
            list: 'secondary',
            url: 'https://maps.yandex.%tld%'
        },
        {
            sid: 52,
            name: 'narodmap',
            list: 'secondary',
            url: 'https://n.maps.yandex.%tld%'
        },
        {
            sid: 54,
            name: 'music',
            list: 'main',
            url: 'https://music.yandex.%tld%'
        },
        {
            sid: 59,
            name: 'disk',
            list: 'main',
            url: 'https://disk.yandex.%tld%'
        },
        {
            sid: 60,
            name: 'partners-news',
            list: 'secondary',
            url: 'https://partner.news.yandex.%tld%'
        },
        {
            sid: 72,
            name: 'work',
            list: 'secondary',
            url: 'https://rabota.yandex.%tld%'
        },
        {
            sid: 73,
            name: 'realty',
            list: 'secondary',
            url: 'https://realty.yandex.%tld%'
        },
        {
            sid: 91,
            name: 'postoffice',
            list: 'main',
            url: 'https://postoffice.yandex.%tld%'
        },
        {
            sid: 97,
            name: 'avia',
            list: 'secondary',
            url: 'https://avia.yandex.%tld%'
        },
        {
            sid: 116,
            name: 'toloka',
            list: 'main',
            url: 'https://toloka.yandex.%tld%'
        },
        {
            sid: 117,
            name: 'telefonia',
            list: 'secondary',
            url: ''
        },
        {
            sid: 119,
            name: 'investments',
            list: 'main',
            url: 'https://invest.yandex.%tld%'
        }
    ];

    let sidInfo = {};

    sids.forEach(function(item) {
        const objWithLoc = (sidsLoc[lang] || sidsLoc.en).SidsDescriptions;

        if (item.sid === subscription.sid) {
            sidInfo = item;
            sidInfo.id = id.v4();
            sidInfo.url = item.url.replace('%tld%', tld);
            sidInfo.locName = objWithLoc[`${item.name}.title`];
            sidInfo.isBlocking = subscription.is_blocking;
            sidInfo.description = objWithLoc[`${item.name}.description`];
        }
    });
    return sidInfo;
}

exports.getSidDescription = getSidDescription;
